/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ASICTransactionReportTypeFormatValidator
implements Validator<ASICTransactionReport> {
    private List<ComparisonResult> getComparisonResults(ASICTransactionReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperatorsNullSafe.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"utiProprietaryID", (String)o.getUtiProprietaryID(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperatorsNullSafe.checkString((String)"secondaryTransactionIdentifier", (String)o.getSecondaryTransactionIdentifier(), (int)1, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"assetClass", (String)o.getAssetClass(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"reportingEntity", (String)o.getReportingEntity(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty2Name", (String)o.getCounterparty2Name(), (int)1, Optional.of(150), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"beneficiary1", (String)o.getBeneficiary1(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"broker", (String)o.getBroker(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"cleared", (String)o.getCleared(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperatorsNullSafe.checkString((String)"centralCounterparty", (String)o.getCentralCounterparty(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"clearingMember", (String)o.getClearingMember(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"platformIdentifier", (String)o.getPlatformIdentifier(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"notionalLeg1", (BigDecimal)o.getNotionalLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"notionalLeg2", (BigDecimal)o.getNotionalLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"totalNotionalQuantityLeg1", (BigDecimal)o.getTotalNotionalQuantityLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"totalNotionalQuantityLeg2", (BigDecimal)o.getTotalNotionalQuantityLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"notionalQuantityLeg1", (BigDecimal)o.getNotionalQuantityLeg1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"notionalQuantityLeg2", (BigDecimal)o.getNotionalQuantityLeg2(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"callAmount", (BigDecimal)o.getCallAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"putAmount", (BigDecimal)o.getPutAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"quantityUnitOfMeasureLeg1", (String)o.getQuantityUnitOfMeasureLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"quantityUnitOfMeasureLeg2", (String)o.getQuantityUnitOfMeasureLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"priceUnitOfMeasure", (String)o.getPriceUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"fixedRateLeg1", (BigDecimal)o.getFixedRateLeg1(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"fixedRateLeg2", (BigDecimal)o.getFixedRateLeg2(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"spreadNotationLeg1", (String)o.getSpreadNotationLeg1(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperatorsNullSafe.checkString((String)"spreadNotationLeg2", (String)o.getSpreadNotationLeg2(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[1-4]"))), ExpressionOperatorsNullSafe.checkNumber((String)"optionPremiumAmount", (BigDecimal)o.getOptionPremiumAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"exchangeRate", (BigDecimal)o.getExchangeRate(), Optional.of(18), Optional.of(13), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"exchangeRateBasis", (String)o.getExchangeRateBasis(), (int)7, Optional.of(7), Optional.of(Pattern.compile("[A-Z]{3,3}/[A-Z]{3,3}"))), ExpressionOperatorsNullSafe.checkString((String)"paymentFrequencyPeriodLeg1", (String)o.getPaymentFrequencyPeriodLeg1(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"paymentFrequencyPeriodLeg2", (String)o.getPaymentFrequencyPeriodLeg2(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"paymentFrequencyPeriodMultiplierLeg1", (Integer)o.getPaymentFrequencyPeriodMultiplierLeg1(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"paymentFrequencyPeriodMultiplierLeg2", (Integer)o.getPaymentFrequencyPeriodMultiplierLeg2(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"underlyingIdentification", (String)o.getUnderlyingIdentification(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), ExpressionOperatorsNullSafe.checkString((String)"underlyingIdentificationType", (String)o.getUnderlyingIdentificationType(), (int)1, Optional.of(1), Optional.of(Pattern.compile("[a-zA-Z]"))), ExpressionOperatorsNullSafe.checkString((String)"underlyingIdOther", (String)o.getUnderlyingIdOther(), (int)1, Optional.of(210), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,210}"))), ExpressionOperatorsNullSafe.checkString((String)"indicatorOfTheFloatingRateLeg2", (String)o.getIndicatorOfTheFloatingRateLeg2(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), ExpressionOperatorsNullSafe.checkString((String)"floatingRateReferencePeriodOfLeg2TimePeriod", (String)o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"floatingRateReferencePeriodOfLeg2Multiplier", (Integer)o.getFloatingRateReferencePeriodOfLeg2Multiplier(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"cdSIndexAttachmentPoint", (BigDecimal)o.getCdSIndexAttachmentPoint(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"cdSIndexDetachmentPoint", (BigDecimal)o.getCdSIndexDetachmentPoint(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"indexFactor", (BigDecimal)o.getIndexFactor(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"packageIdentifier", (String)o.getPackageIdentifier(), (int)1, Optional.of(35), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,35}"))), ExpressionOperatorsNullSafe.checkString((String)"priorUTI", (String)o.getPriorUTI(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"priorUtiProprietary", (String)o.getPriorUtiProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperatorsNullSafe.checkString((String)"eventIdentifier", (String)o.getEventIdentifier(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"newDerivativeTradeRepository", (String)o.getNewDerivativeTradeRepository(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkNumber((String)"valuationAmount", (BigDecimal)o.getValuationAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"delta", (BigDecimal)o.getDelta(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"collateralPortfolioCodeInitialMargin", (String)o.getCollateralPortfolioCodeInitialMargin(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"collateralPortfolioCodeVariationMargin", (String)o.getCollateralPortfolioCodeVariationMargin(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"executionAgentOfCounterparty2DTCC", (String)o.getExecutionAgentOfCounterparty2DTCC(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"ASICTransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"ASICTransactionReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"ASICTransactionReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"ASICTransactionReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

