/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.valuation.meta.ASICValuationReportMeta;
import iso20022.auth030.asic.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ASICValuationReport", builder=ASICValuationReportBuilderImpl.class, version="5.55.0")
@RuneDataType(value="ASICValuationReport", model="drr", builder=ASICValuationReportBuilderImpl.class, version="5.55.0")
public interface ASICValuationReport
extends RosettaModelObject {
    public static final ASICValuationReportMeta metaData = new ASICValuationReportMeta();

    public String getUniqueTransactionIdentifier();

    public String getUtiProprietaryID();

    public String getReportingEntity();

    public String getCounterparty1();

    public String getCounterparty2();

    public Boolean getCounterparty2IdentifierTypeIndicator();

    public String getExecutionAgentOfTheCounterparty1();

    public String getActionType();

    public ZonedDateTime getReportingTimestamp();

    public String getReportSubmittingEntityID();

    public String getSmallScaleBuySideEntityIndicator();

    public ZonedDateTime getValuationTimestamp();

    public BigDecimal getValuationAmount();

    public ISOCurrencyCodeEnum getValuationCurrency();

    public ValuationType1Code getValuationMethod();

    public BigDecimal getDelta();

    public Date getNextFloatingReferenceResetDateLeg1();

    public Date getNextFloatingReferenceResetDateLeg2();

    public String getTechnicalRecordId();

    public String getExecutionAgentOfTheCounterparty2();

    public ASICValuationReport build();

    public ASICValuationReportBuilder toBuilder();

    public static ASICValuationReportBuilder builder() {
        return new ASICValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends ASICValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ASICValuationReport> getType() {
        return ASICValuationReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("utiProprietaryID"), String.class, (Object)this.getUtiProprietaryID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingEntity"), String.class, (Object)this.getReportingEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, (Object)this.getCounterparty2IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, (Object)this.getExecutionAgentOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), String.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, (Object)this.getExecutionAgentOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ASICValuationReportBuilderImpl
    implements ASICValuationReportBuilder {
        protected String uniqueTransactionIdentifier;
        protected String utiProprietaryID;
        protected String reportingEntity;
        protected String counterparty1;
        protected String counterparty2;
        protected Boolean counterparty2IdentifierTypeIndicator;
        protected String executionAgentOfTheCounterparty1;
        protected String actionType;
        protected ZonedDateTime reportingTimestamp;
        protected String reportSubmittingEntityID;
        protected String smallScaleBuySideEntityIndicator;
        protected ZonedDateTime valuationTimestamp;
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ValuationType1Code valuationMethod;
        protected BigDecimal delta;
        protected Date nextFloatingReferenceResetDateLeg1;
        protected Date nextFloatingReferenceResetDateLeg2;
        protected String technicalRecordId;
        protected String executionAgentOfTheCounterparty2;

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="utiProprietaryID")
        @RuneAttribute(value="utiProprietaryID")
        public String getUtiProprietaryID() {
            return this.utiProprietaryID;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public String getReportingEntity() {
            return this.reportingEntity;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public Boolean getCounterparty2IdentifierTypeIndicator() {
            return this.counterparty2IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public String getExecutionAgentOfTheCounterparty1() {
            return this.executionAgentOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public String getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public String getExecutionAgentOfTheCounterparty2() {
            return this.executionAgentOfTheCounterparty2;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public ASICValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="utiProprietaryID")
        @RuneAttribute(value="utiProprietaryID")
        public ASICValuationReportBuilder setUtiProprietaryID(String _utiProprietaryID) {
            this.utiProprietaryID = _utiProprietaryID == null ? null : _utiProprietaryID;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public ASICValuationReportBuilder setReportingEntity(String _reportingEntity) {
            this.reportingEntity = _reportingEntity == null ? null : _reportingEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public ASICValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public ASICValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public ASICValuationReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean _counterparty2IdentifierTypeIndicator) {
            this.counterparty2IdentifierTypeIndicator = _counterparty2IdentifierTypeIndicator == null ? null : _counterparty2IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public ASICValuationReportBuilder setExecutionAgentOfTheCounterparty1(String _executionAgentOfTheCounterparty1) {
            this.executionAgentOfTheCounterparty1 = _executionAgentOfTheCounterparty1 == null ? null : _executionAgentOfTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ASICValuationReportBuilder setActionType(String _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ASICValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public ASICValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public ASICValuationReportBuilder setSmallScaleBuySideEntityIndicator(String _smallScaleBuySideEntityIndicator) {
            this.smallScaleBuySideEntityIndicator = _smallScaleBuySideEntityIndicator == null ? null : _smallScaleBuySideEntityIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ASICValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public ASICValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ASICValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ASICValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public ASICValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public ASICValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public ASICValuationReportBuilder setExecutionAgentOfTheCounterparty2(String _executionAgentOfTheCounterparty2) {
            this.executionAgentOfTheCounterparty2 = _executionAgentOfTheCounterparty2 == null ? null : _executionAgentOfTheCounterparty2;
            return this;
        }

        @Override
        public ASICValuationReport build() {
            return new ASICValuationReportImpl(this);
        }

        @Override
        public ASICValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public ASICValuationReportBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUtiProprietaryID() != null) {
                return true;
            }
            if (this.getReportingEntity() != null) {
                return true;
            }
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierTypeIndicator() != null) {
                return true;
            }
            if (this.getExecutionAgentOfTheCounterparty1() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getSmallScaleBuySideEntityIndicator() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg1() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg2() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            return this.getExecutionAgentOfTheCounterparty2() != null;
        }

        public ASICValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ASICValuationReportBuilder o = (ASICValuationReportBuilder)other;
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUtiProprietaryID(), (Object)o.getUtiProprietaryID(), this::setUtiProprietaryID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingEntity(), (Object)o.getReportingEntity(), this::setReportingEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierTypeIndicator(), (Object)o.getCounterparty2IdentifierTypeIndicator(), this::setCounterparty2IdentifierTypeIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfTheCounterparty1(), (Object)o.getExecutionAgentOfTheCounterparty1(), this::setExecutionAgentOfTheCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSmallScaleBuySideEntityIndicator(), (Object)o.getSmallScaleBuySideEntityIndicator(), this::setSmallScaleBuySideEntityIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg1(), (Object)o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg2(), (Object)o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfTheCounterparty2(), (Object)o.getExecutionAgentOfTheCounterparty2(), this::setExecutionAgentOfTheCounterparty2, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ASICValuationReport _that = this.getType().cast(o);
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.utiProprietaryID, _that.getUtiProprietaryID())) {
                return false;
            }
            if (!Objects.equals(this.reportingEntity, _that.getReportingEntity())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationMethod, _that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            return Objects.equals(this.executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.utiProprietaryID != null ? this.utiProprietaryID.hashCode() : 0);
            _result = 31 * _result + (this.reportingEntity != null ? this.reportingEntity.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierTypeIndicator != null ? this.counterparty2IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty1 != null ? this.executionAgentOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? this.valuationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty2 != null ? this.executionAgentOfTheCounterparty2.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ASICValuationReportBuilder {uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", utiProprietaryID=" + this.utiProprietaryID + ", reportingEntity=" + this.reportingEntity + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", actionType=" + this.actionType + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf(this.valuationMethod) + ", delta=" + String.valueOf(this.delta) + ", nextFloatingReferenceResetDateLeg1=" + String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 + "}";
        }
    }

    public static interface ASICValuationReportBuilder
    extends ASICValuationReport,
    RosettaModelObjectBuilder {
        public ASICValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        public ASICValuationReportBuilder setUtiProprietaryID(String var1);

        public ASICValuationReportBuilder setReportingEntity(String var1);

        public ASICValuationReportBuilder setCounterparty1(String var1);

        public ASICValuationReportBuilder setCounterparty2(String var1);

        public ASICValuationReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean var1);

        public ASICValuationReportBuilder setExecutionAgentOfTheCounterparty1(String var1);

        public ASICValuationReportBuilder setActionType(String var1);

        public ASICValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        public ASICValuationReportBuilder setReportSubmittingEntityID(String var1);

        public ASICValuationReportBuilder setSmallScaleBuySideEntityIndicator(String var1);

        public ASICValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        public ASICValuationReportBuilder setValuationAmount(BigDecimal var1);

        public ASICValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        public ASICValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        public ASICValuationReportBuilder setDelta(BigDecimal var1);

        public ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        public ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        public ASICValuationReportBuilder setTechnicalRecordId(String var1);

        public ASICValuationReportBuilder setExecutionAgentOfTheCounterparty2(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("utiProprietaryID"), String.class, (Object)this.getUtiProprietaryID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingEntity"), String.class, (Object)this.getReportingEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, (Object)this.getCounterparty2IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, (Object)this.getExecutionAgentOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), String.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, (Object)this.getExecutionAgentOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ASICValuationReportBuilder prune();
    }

    public static class ASICValuationReportImpl
    implements ASICValuationReport {
        private final String uniqueTransactionIdentifier;
        private final String utiProprietaryID;
        private final String reportingEntity;
        private final String counterparty1;
        private final String counterparty2;
        private final Boolean counterparty2IdentifierTypeIndicator;
        private final String executionAgentOfTheCounterparty1;
        private final String actionType;
        private final ZonedDateTime reportingTimestamp;
        private final String reportSubmittingEntityID;
        private final String smallScaleBuySideEntityIndicator;
        private final ZonedDateTime valuationTimestamp;
        private final BigDecimal valuationAmount;
        private final ISOCurrencyCodeEnum valuationCurrency;
        private final ValuationType1Code valuationMethod;
        private final BigDecimal delta;
        private final Date nextFloatingReferenceResetDateLeg1;
        private final Date nextFloatingReferenceResetDateLeg2;
        private final String technicalRecordId;
        private final String executionAgentOfTheCounterparty2;

        protected ASICValuationReportImpl(ASICValuationReportBuilder builder) {
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.utiProprietaryID = builder.getUtiProprietaryID();
            this.reportingEntity = builder.getReportingEntity();
            this.counterparty1 = builder.getCounterparty1();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2IdentifierTypeIndicator = builder.getCounterparty2IdentifierTypeIndicator();
            this.executionAgentOfTheCounterparty1 = builder.getExecutionAgentOfTheCounterparty1();
            this.actionType = builder.getActionType();
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.smallScaleBuySideEntityIndicator = builder.getSmallScaleBuySideEntityIndicator();
            this.valuationTimestamp = builder.getValuationTimestamp();
            this.valuationAmount = builder.getValuationAmount();
            this.valuationCurrency = builder.getValuationCurrency();
            this.valuationMethod = builder.getValuationMethod();
            this.delta = builder.getDelta();
            this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
            this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.executionAgentOfTheCounterparty2 = builder.getExecutionAgentOfTheCounterparty2();
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="utiProprietaryID")
        @RuneAttribute(value="utiProprietaryID")
        public String getUtiProprietaryID() {
            return this.utiProprietaryID;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public String getReportingEntity() {
            return this.reportingEntity;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public Boolean getCounterparty2IdentifierTypeIndicator() {
            return this.counterparty2IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public String getExecutionAgentOfTheCounterparty1() {
            return this.executionAgentOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public String getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public String getExecutionAgentOfTheCounterparty2() {
            return this.executionAgentOfTheCounterparty2;
        }

        @Override
        public ASICValuationReport build() {
            return this;
        }

        @Override
        public ASICValuationReportBuilder toBuilder() {
            ASICValuationReportBuilder builder = ASICValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ASICValuationReportBuilder builder) {
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getUtiProprietaryID()).ifPresent(builder::setUtiProprietaryID);
            Optional.ofNullable(this.getReportingEntity()).ifPresent(builder::setReportingEntity);
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCounterparty2IdentifierTypeIndicator()).ifPresent(builder::setCounterparty2IdentifierTypeIndicator);
            Optional.ofNullable(this.getExecutionAgentOfTheCounterparty1()).ifPresent(builder::setExecutionAgentOfTheCounterparty1);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
            Optional.ofNullable(this.getSmallScaleBuySideEntityIndicator()).ifPresent(builder::setSmallScaleBuySideEntityIndicator);
            Optional.ofNullable(this.getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
            Optional.ofNullable(this.getValuationAmount()).ifPresent(builder::setValuationAmount);
            Optional.ofNullable(this.getValuationCurrency()).ifPresent(builder::setValuationCurrency);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
            Optional.ofNullable(this.getDelta()).ifPresent(builder::setDelta);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getExecutionAgentOfTheCounterparty2()).ifPresent(builder::setExecutionAgentOfTheCounterparty2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ASICValuationReport _that = this.getType().cast(o);
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.utiProprietaryID, _that.getUtiProprietaryID())) {
                return false;
            }
            if (!Objects.equals(this.reportingEntity, _that.getReportingEntity())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationMethod, _that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            return Objects.equals(this.executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.utiProprietaryID != null ? this.utiProprietaryID.hashCode() : 0);
            _result = 31 * _result + (this.reportingEntity != null ? this.reportingEntity.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierTypeIndicator != null ? this.counterparty2IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty1 != null ? this.executionAgentOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? this.valuationMethod.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty2 != null ? this.executionAgentOfTheCounterparty2.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ASICValuationReport {uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", utiProprietaryID=" + this.utiProprietaryID + ", reportingEntity=" + this.reportingEntity + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", actionType=" + this.actionType + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf(this.valuationMethod) + ", delta=" + String.valueOf(this.delta) + ", nextFloatingReferenceResetDateLeg1=" + String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 + "}";
        }
    }
}

