/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CFTCPart45TransactionReportSellerIdentifierCondition")
@ImplementedBy(value=Default.class)
public interface CFTCPart45TransactionReportSellerIdentifierCondition
extends Validator<CFTCPart45TransactionReport> {
    public static final String NAME = "CFTCPart45TransactionReportSellerIdentifierCondition";
    public static final String DEFINITION = "if (payerIdentifierLeg1 is absent and payerIdentifierLeg2 is absent) and (receiverIdentifierLeg1 is absent and receiverIdentifierLeg2 is absent) then (sellerIdentifier exists and (sellerIdentifier = counterparty1 or sellerIdentifier = counterparty2)) else sellerIdentifier is absent";

    public static class NoOp
    implements CFTCPart45TransactionReportSellerIdentifierCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CFTCPart45TransactionReportSellerIdentifierCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            ComparisonResult result = this.executeDataRule(cFTCPart45TransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CFTCPart45TransactionReportSellerIdentifierCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportSellerIdentifierCondition.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CFTCPart45TransactionReportSellerIdentifierCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportSellerIdentifierCondition.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getPayerIdentifierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPayerIdentifierLeg1())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getPayerIdentifierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPayerIdentifierLeg2()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getReceiverIdentifierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg1())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getReceiverIdentifierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg2())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getSellerIdentifier", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSellerIdentifier())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getSellerIdentifier", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSellerIdentifier()), (Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getCounterparty1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCounterparty1()), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getSellerIdentifier", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSellerIdentifier()), (Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getCounterparty2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCounterparty2()), (CardinalityOperator)CardinalityOperator.All)));
                }
                return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getSellerIdentifier", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSellerIdentifier()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

