/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.CommodityCommodityLeg2;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommoditySwapFixedFloat;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityLeg2Default.class)
public abstract class CommodityLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityCommodityLeg2 commodityCommodityLeg2;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
    @Inject
    protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;

    public CommodityPayout evaluate(Product product) {
        CommodityPayout commodityLeg2;
        CommodityPayout.CommodityPayoutBuilder commodityLeg2Builder = this.doEvaluate(product);
        if (commodityLeg2Builder == null) {
            commodityLeg2 = null;
        } else {
            commodityLeg2 = commodityLeg2Builder.build();
            this.objectValidator.validate(CommodityPayout.class, (RosettaModelObject)commodityLeg2);
        }
        return commodityLeg2;
    }

    protected abstract CommodityPayout.CommodityPayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends CommodityPayout> commodityPayouts(Product var1);

    public static class CommodityLeg2Default
    extends CommodityLeg2 {
        @Override
        protected CommodityPayout.CommodityPayoutBuilder doEvaluate(Product product) {
            CommodityPayout.CommodityPayoutBuilder commodityLeg2 = CommodityPayout.builder();
            return this.assignOutput(commodityLeg2, product);
        }

        protected CommodityPayout.CommodityPayoutBuilder assignOutput(CommodityPayout.CommodityPayoutBuilder commodityLeg2, Product product) {
            Boolean boolean1;
            Boolean boolean0 = this.isCommoditySwapFloatFloat.evaluate(product);
            commodityLeg2 = boolean0 != null && boolean0 != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityCommodityLeg2.evaluate(this.commodityPayouts(product).getMulti())) : ((boolean1 = this.isCommoditySwapFixedFloat.evaluate(product)) != null && boolean1 != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityPayouts(product).get()) : null);
            return Optional.ofNullable(commodityLeg2).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends CommodityPayout> commodityPayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout());
        }
    }
}

