/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.math.Measure;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ETDNotionalFutureDefault.class)
public abstract class ETDNotionalFuture
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Measure evaluate(List<? extends TradeLot> tradeLot) {
        Measure notional;
        Measure.MeasureBuilder notionalBuilder = this.doEvaluate(tradeLot);
        if (notionalBuilder == null) {
            notional = null;
        } else {
            notional = notionalBuilder.build();
            this.objectValidator.validate(Measure.class, (RosettaModelObject)notional);
        }
        return notional;
    }

    protected abstract Measure.MeasureBuilder doEvaluate(List<? extends TradeLot> var1);

    protected abstract MapperS<BigDecimal> quantityCurrency(List<? extends TradeLot> var1);

    protected abstract MapperS<BigDecimal> quantityFinancial(List<? extends TradeLot> var1);

    protected abstract MapperS<? extends FieldWithMetaPriceSchedule> price(List<? extends TradeLot> var1);

    protected abstract MapperS<BigDecimal> amount(List<? extends TradeLot> var1);

    protected abstract MapperS<? extends UnitType> amountUnit(List<? extends TradeLot> var1);

    public static class ETDNotionalFutureDefault
    extends ETDNotionalFuture {
        @Override
        protected Measure.MeasureBuilder doEvaluate(List<? extends TradeLot> tradeLot) {
            if (tradeLot == null) {
                tradeLot = Collections.emptyList();
            }
            Measure.MeasureBuilder notional = Measure.builder();
            return this.assignOutput(notional, tradeLot);
        }

        protected Measure.MeasureBuilder assignOutput(Measure.MeasureBuilder notional, List<? extends TradeLot> tradeLot) {
            notional = (Measure.MeasureBuilder)this.toBuilder((RosettaModelObject)Measure.builder().setValue((BigDecimal)this.amount(tradeLot).get()).setUnit((UnitType)this.amountUnit(tradeLot).get()).build());
            return Optional.ofNullable(notional).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> quantityCurrency(List<? extends TradeLot> tradeLot) {
            MapperC thenArg0 = MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
            return MapperS.of((Object)((BigDecimal)thenArg1.get()));
        }

        @Override
        protected MapperS<BigDecimal> quantityFinancial(List<? extends TradeLot> tradeLot) {
            MapperC thenArg0 = MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
            return MapperS.of((Object)((BigDecimal)thenArg1.get()));
        }

        @Override
        protected MapperS<? extends FieldWithMetaPriceSchedule> price(List<? extends TradeLot> tradeLot) {
            return MapperS.of((Object)((FieldWithMetaPriceSchedule)MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).get()));
        }

        @Override
        protected MapperS<BigDecimal> amount(List<? extends TradeLot> tradeLot) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.quantityCurrency(tradeLot);
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperMaths.multiply(this.quantityFinancial(tradeLot), (Mapper)this.price(tradeLot).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends UnitType> amountUnit(List<? extends TradeLot> tradeLot) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity());
                MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get());
                MapperS thenArg2 = MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg1.get()));
                return thenArg2.mapSingleToItem(item -> item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()));
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.price(tradeLot).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit());
            }
            return MapperS.ofNull();
        }
    }
}

