/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;
import java.time.ZonedDateTime;

@ImplementedBy(value=ExtractDateFromDateTimeDefault.class)
public abstract class ExtractDateFromDateTime
implements RosettaFunction {
    public Date evaluate(ZonedDateTime dateTimeInput) {
        Date dateOutput = this.doEvaluate(dateTimeInput);
        return dateOutput;
    }

    protected abstract Date doEvaluate(ZonedDateTime var1);

    public static class ExtractDateFromDateTimeDefault
    extends ExtractDateFromDateTime {
        @Override
        protected Date doEvaluate(ZonedDateTime dateTimeInput) {
            Date dateOutput = null;
            return this.assignOutput(dateOutput, dateTimeInput);
        }

        protected Date assignOutput(Date dateOutput, ZonedDateTime dateTimeInput) {
            dateOutput = (Date)MapperS.of((Object)dateTimeInput).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get();
            return dateOutput;
        }
    }
}

