/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.event.common.Trade;
import cdm.product.asset.ReferenceObligation;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.GetProductIdentifierFilteringISIN;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetBasketConstituentsProductIdentifierDefault.class)
public abstract class GetBasketConstituentsProductIdentifier
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetProductIdentifierFilteringISIN getProductIdentifierFilteringISIN;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<? extends ProductIdentifier> evaluate(Trade trade) {
        List productIdentifiers;
        List<ProductIdentifier.ProductIdentifierBuilder> productIdentifiersBuilder = this.doEvaluate(trade);
        if (productIdentifiersBuilder == null) {
            productIdentifiers = null;
        } else {
            productIdentifiers = productIdentifiersBuilder.stream().map(ProductIdentifier::build).collect(Collectors.toList());
            this.objectValidator.validate(ProductIdentifier.class, productIdentifiers);
        }
        return productIdentifiers;
    }

    protected abstract List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Trade var1);

    protected abstract MapperS<? extends Product> product(Trade var1);

    protected abstract MapperC<? extends Product> basketConstituents(Trade var1);

    protected abstract MapperC<? extends ReferenceObligation> referenceObligations(Trade var1);

    public static class GetBasketConstituentsProductIdentifierDefault
    extends GetBasketConstituentsProductIdentifier {
        @Override
        protected List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Trade trade) {
            ArrayList<ProductIdentifier.ProductIdentifierBuilder> productIdentifiers = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
            return this.assignOutput(productIdentifiers, trade);
        }

        protected List<ProductIdentifier.ProductIdentifierBuilder> assignOutput(List<ProductIdentifier.ProductIdentifierBuilder> productIdentifiers, Trade trade) {
            MapperListOfLists thenArg0 = this.basketConstituents(trade).mapItemToList(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getSecurity", _product -> _product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSecurity", _product -> _product.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getLoan", _product -> _product.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getLoan", _product -> _product.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getCommodity", _product -> _product.getCommodity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getIndex", _product -> _product.getIndex())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
            productIdentifiers.addAll(this.toBuilder(thenArg0.mapListToItem(item -> MapperS.of((Object)this.getProductIdentifierFilteringISIN.evaluate(item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()))).getMulti()));
            MapperListOfLists thenArg1 = this.referenceObligations(trade).mapItemToList(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getSecurity", referenceObligation -> referenceObligation.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getLoan", referenceObligation -> referenceObligation.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getLoan", referenceObligation -> referenceObligation.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
            productIdentifiers.addAll(this.toBuilder(thenArg1.mapListToItem(item -> MapperS.of((Object)this.getProductIdentifierFilteringISIN.evaluate(item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()))).getMulti()));
            return Optional.ofNullable(productIdentifiers).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends Product> product(Trade trade) {
            return MapperS.of((Object)this.productForTrade.evaluate(trade));
        }

        @Override
        protected MapperC<? extends Product> basketConstituents(Trade trade) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate((Product)this.product(trade).get())).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate((Product)this.product(trade).get())).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isSingleCommodityPayoutProduct.evaluate((Product)this.product(trade).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent());
            }
            return MapperC.ofNull();
        }

        @Override
        protected MapperC<? extends ReferenceObligation> referenceObligations(Trade trade) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation());
            }
            return MapperC.ofNull();
        }
    }
}

