/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.Contract_Price_Monetary;
import drr.regulation.common.functions.Create_PriceReportablePeriod;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportablePricePeriodDefault.class)
public abstract class GetReportablePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Contract_Price_Monetary contract_Price_Monetary;
    @Inject
    protected Create_PriceReportablePeriod create_PriceReportablePeriod;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetPriceNotation getPriceNotation;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

    public List<? extends PriceReportablePeriod> evaluate(ReportableEvent reportableEvent) {
        List reportablePeriod;
        List<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriodBuilder = this.doEvaluate(reportableEvent);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.stream().map(PriceReportablePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceReportablePeriod.class, reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent var1);

    protected abstract MapperS<? extends PriceSchedule> priceSchedule(ReportableEvent var1);

    protected abstract MapperS<PriceNotationEnum> priceNotation(ReportableEvent var1);

    public static class GetReportablePricePeriodDefault
    extends GetReportablePricePeriod {
        @Override
        protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(ReportableEvent reportableEvent) {
            ArrayList<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriod = new ArrayList<PriceReportablePeriod.PriceReportablePeriodBuilder>();
            return this.assignOutput(reportablePeriod, reportableEvent);
        }

        protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> assignOutput(List<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriod, ReportableEvent reportableEvent) {
            if (ExpressionOperatorsNullSafe.exists(this.customizedSchedule(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                reportablePeriod.addAll(this.toBuilder(this.priceSchedule(reportableEvent).mapC("getDatedValue", _priceSchedule -> _priceSchedule.getDatedValue()).mapItem(pricePeriod -> {
                    MapperC thenArg0 = this.customizedSchedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).filterItemNullSafe(customPeriod -> ExpressionOperatorsNullSafe.areEqual((Mapper)pricePeriod.map("getDate", datedValue -> datedValue.getDate()), (Mapper)customPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), (CardinalityOperator)CardinalityOperator.All).get());
                    MapperS thenArg1 = MapperS.of((Object)((SchedulePeriod)thenArg0.get()));
                    return thenArg1.mapSingleToItem(matchingCustomPeriod -> MapperS.of((Object)this.create_PriceReportablePeriod.evaluate((BigDecimal)pricePeriod.map("getValue", datedValue -> datedValue.getValue()).get(), (Date)matchingCustomPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()).get(), (Date)matchingCustomPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).get(), (PriceNotationEnum)((Object)((Object)((Object)this.priceNotation(reportableEvent).get()))))));
                }).getMulti()));
            } else {
                reportablePeriod.addAll(this.toBuilder(this.priceSchedule(reportableEvent).mapC("getDatedValue", _priceSchedule -> _priceSchedule.getDatedValue()).mapItem(pricePeriod -> MapperS.of((Object)this.create_PriceReportablePeriod.evaluate((BigDecimal)pricePeriod.map("getValue", datedValue -> datedValue.getValue()).get(), (Date)pricePeriod.map("getDate", datedValue -> datedValue.getDate()).get(), null, (PriceNotationEnum)((Object)((Object)this.priceNotation(reportableEvent).get()))))).getMulti()));
            }
            return Optional.ofNullable(reportablePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent) {
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).first();
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Option.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getSchedule", optionPayout -> optionPayout.getSchedule());
            }
            Boolean _boolean = this.qualify_Commodity_Forward.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)));
            if (_boolean != null && _boolean.booleanValue()) {
                return MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends PriceSchedule> priceSchedule(ReportableEvent reportableEvent) {
            return MapperS.of((Object)((PriceSchedule)MapperC.of(this.contract_Price_Monetary.evaluate(reportableEvent)).get()));
        }

        @Override
        protected MapperS<PriceNotationEnum> priceNotation(ReportableEvent reportableEvent) {
            return MapperS.of((Object)((Object)this.getPriceNotation.evaluate((PriceSchedule)this.priceSchedule(reportableEvent).get())));
        }
    }
}

