/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.PositionForEvent;
import drr.regulation.common.functions.ProductForPosition;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ProductForEventDefault.class)
public abstract class ProductForEvent
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PositionForEvent positionForEvent;
    @Inject
    protected ProductForPosition productForPosition;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Product evaluate(ReportableEvent reportableEvent) {
        Product product;
        Product.ProductBuilder productBuilder = this.doEvaluate(reportableEvent);
        if (productBuilder == null) {
            product = null;
        } else {
            product = productBuilder.build();
            this.objectValidator.validate(Product.class, (RosettaModelObject)product);
        }
        return product;
    }

    protected abstract Product.ProductBuilder doEvaluate(ReportableEvent var1);

    public static class ProductForEventDefault
    extends ProductForEvent {
        @Override
        protected Product.ProductBuilder doEvaluate(ReportableEvent reportableEvent) {
            Product.ProductBuilder product = Product.builder();
            return this.assignOutput(product, reportableEvent);
        }

        protected Product.ProductBuilder assignOutput(Product.ProductBuilder product, ReportableEvent reportableEvent) {
            product = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.tradeForEvent.evaluate(reportableEvent))).getOrDefault(Boolean.valueOf(false)) != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)this.productForTrade.evaluate(this.tradeForEvent.evaluate(reportableEvent))) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.positionForEvent.evaluate(reportableEvent))).getOrDefault(Boolean.valueOf(false)) != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)this.productForPosition.evaluate(this.positionForEvent.evaluate(reportableEvent))) : null);
            return Optional.ofNullable(product).map(o -> o.prune()).orElse(null);
        }
    }
}

