/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ESMATransactionInformation;
import java.util.List;
import java.util.stream.Collectors;

public class ESMATransactionInformationValidator
implements Validator<ESMATransactionInformation> {
    private List<ComparisonResult> getComparisonResults(ESMATransactionInformation o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperatorsNullSafe.checkCardinality((String)"admittedToTradingVenue", (int)(o.getAdmittedToTradingVenue() != null ? 1 : 0), (int)0, (int)1), ExpressionOperatorsNullSafe.checkCardinality((String)"underlierTradedOnTradingVenue", (int)(o.getUnderlierTradedOnTradingVenue() != null ? 1 : 0), (int)0, (int)1), ExpressionOperatorsNullSafe.checkCardinality((String)"duration", (int)(o.getDuration() != null ? 1 : 0), (int)0, (int)1)});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMATransactionInformation o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"ESMATransactionInformation", (ValidationResult.ValidationType)ValidationResult.ValidationType.CARDINALITY, (String)"ESMATransactionInformation", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"ESMATransactionInformation", (ValidationResult.ValidationType)ValidationResult.ValidationType.CARDINALITY, (String)"ESMATransactionInformation", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

