/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ReportingRegimeSupervisorInformation")
@ImplementedBy(value=Default.class)
public interface ReportingRegimeSupervisorInformation
extends Validator<ReportingRegime> {
    public static final String NAME = "ReportingRegimeSupervisorInformation";
    public static final String DEFINITION = "if regimeName = RegimeNameEnum -> DoddFrankAct then supervisoryBody = SupervisoryBodyEnum -> CFTC or supervisoryBody = SupervisoryBodyEnum -> SEC";

    public static class NoOp
    implements ReportingRegimeSupervisorInformation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ReportingRegimeSupervisorInformation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
            ComparisonResult result = this.executeDataRule(reportingRegime);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ReportingRegimeSupervisorInformation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReportingRegime", (RosettaPath)path, (String)ReportingRegimeSupervisorInformation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ReportingRegimeSupervisorInformation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReportingRegime", (RosettaPath)path, (String)ReportingRegimeSupervisorInformation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ReportingRegime reportingRegime) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)reportingRegime).map("getRegimeName", _reportingRegime -> _reportingRegime.getRegimeName()).map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.DODD_FRANK_ACT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)reportingRegime).map("getSupervisoryBody", _reportingRegime -> _reportingRegime.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum0 -> fieldWithMetaSupervisoryBodyEnum0 == null ? null : fieldWithMetaSupervisoryBodyEnum0.getValue()), (Mapper)MapperS.of((Object)((Object)SupervisoryBodyEnum.CFTC)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)reportingRegime).map("getSupervisoryBody", _reportingRegime -> _reportingRegime.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum1 -> fieldWithMetaSupervisoryBodyEnum1 == null ? null : fieldWithMetaSupervisoryBodyEnum1.getValue()), (Mapper)MapperS.of((Object)((Object)SupervisoryBodyEnum.SEC)), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

