/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentCurrencyRule;
import javax.inject.Inject;

@ImplementedBy(value=OtherPaymentCurrencyRuleDefault.class)
public abstract class OtherPaymentCurrencyRule
implements ReportFunction<TransferState, ISOCurrencyCodeEnum> {
    @Inject
    protected CDEOtherPaymentCurrencyRule cDEOtherPaymentCurrencyRule;
    @Inject
    protected IsOtherPayment isOtherPayment;

    public ISOCurrencyCodeEnum evaluate(TransferState input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransferState var1);

    public static class OtherPaymentCurrencyRuleDefault
    extends OtherPaymentCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransferState input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransferState input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isOtherPayment.evaluate((TransferState)item.get()));
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.cDEOtherPaymentCurrencyRule.evaluate((TransferState)item.get()))).get();
            return output;
        }
    }
}

