/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_2034_01")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2034_01
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_2034_01";
    public static final String DEFINITION = "if IsVRAllowedForActionType(actionType) then ([\"ISDA\", \"CDEA\", \"EUMA\", \"FPCA\", \"FMAT\", \"DERV\", \"CMOP\", \"CHMA\", \"IDMA\", \"EFMA\", \"GMRA\", \"GMSL\", \"BIAG\", \"OTHR\"] any = masterAgreementType)";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_2034_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_2034_01 {
        @Inject
        protected IsVRAllowedForActionType isVRAllowedForActionType;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_2034_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2034_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_2034_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2034_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                Boolean _boolean = this.isVRAllowedForActionType.evaluate((String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)"ISDA"), MapperS.of((Object)"CDEA"), MapperS.of((Object)"EUMA"), MapperS.of((Object)"FPCA"), MapperS.of((Object)"FMAT"), MapperS.of((Object)"DERV"), MapperS.of((Object)"CMOP"), MapperS.of((Object)"CHMA"), MapperS.of((Object)"IDMA"), MapperS.of((Object)"EFMA"), MapperS.of((Object)"GMRA"), MapperS.of((Object)"GMSL"), MapperS.of((Object)"BIAG"), MapperS.of((Object)"OTHR")}), (Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getMasterAgreementType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getMasterAgreementType()), (CardinalityOperator)CardinalityOperator.Any);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

