/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousQuantitySchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.GetReportableQuantityPeriodLeg1;
import drr.regulation.common.functions.TradeForEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=UKEMIRReportableQuantityPeriodLeg1Default.class)
public abstract class UKEMIRReportableQuantityPeriodLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_ContinuousQuantitySchedule create_ContinuousQuantitySchedule;
    @Inject
    protected GetExpirationDate getExpirationDate;
    @Inject
    protected GetReportableQuantityPeriodLeg1 getReportableQuantityPeriodLeg1;
    @Inject
    protected TradeForEvent tradeForEvent;

    public List<? extends QuantityReportablePeriod> evaluate(TransactionReportInstruction transactionReportInstruction) {
        List emirReportableQuantityPeriods;
        List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirReportableQuantityPeriodsBuilder = this.doEvaluate(transactionReportInstruction);
        if (emirReportableQuantityPeriodsBuilder == null) {
            emirReportableQuantityPeriods = null;
        } else {
            emirReportableQuantityPeriods = emirReportableQuantityPeriodsBuilder.stream().map(QuantityReportablePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(QuantityReportablePeriod.class, emirReportableQuantityPeriods);
        }
        return emirReportableQuantityPeriods;
    }

    protected abstract List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    protected abstract MapperS<Date> expirationDate(TransactionReportInstruction var1);

    protected abstract MapperC<? extends QuantityReportablePeriod> genericReportableQuantitySchedule(TransactionReportInstruction var1);

    public static class UKEMIRReportableQuantityPeriodLeg1Default
    extends UKEMIRReportableQuantityPeriodLeg1 {
        @Override
        protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction) {
            ArrayList<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirReportableQuantityPeriods = new ArrayList<QuantityReportablePeriod.QuantityReportablePeriodBuilder>();
            return this.assignOutput(emirReportableQuantityPeriods, transactionReportInstruction);
        }

        protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> assignOutput(List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirReportableQuantityPeriods, TransactionReportInstruction transactionReportInstruction) {
            emirReportableQuantityPeriods = this.toBuilder(this.create_ContinuousQuantitySchedule.evaluate(this.genericReportableQuantitySchedule(transactionReportInstruction).getMulti(), (Date)this.expirationDate(transactionReportInstruction).get()));
            return Optional.ofNullable(emirReportableQuantityPeriods).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.getExpirationDate.evaluate(transactionReportInstruction));
        }

        @Override
        protected MapperC<? extends QuantityReportablePeriod> genericReportableQuantitySchedule(TransactionReportInstruction transactionReportInstruction) {
            return MapperC.of(this.getReportableQuantityPeriodLeg1.evaluate(this.tradeForEvent.evaluate(transactionReportInstruction)));
        }
    }
}

