/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import javax.inject.Inject;

@ImplementedBy(value=OptionStyleRuleDefault.class)
public abstract class OptionStyleRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected IsAllowableActionForJFSA isAllowableActionForJFSA;
    @Inject
    protected IsCap isCap;
    @Inject
    protected IsFloor isFloor;
    @Inject
    protected IsOption isOption;
    @Inject
    protected TradeForEvent tradeForEvent;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class OptionStyleRuleDefault
    extends OptionStyleRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForJFSA.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()));
            output = (String)thenArg2.mapSingleToItem(item -> {
                if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFloor.evaluate((Product)item.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCap.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)"EURO");
                }
                Boolean _boolean = this.isOption.evaluate((Product)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)((OptionPayout)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).mapSingleToItem(_item -> {
                        if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)"AMER");
                        }
                        if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)"EURO");
                        }
                        if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)"BERM");
                        }
                        return MapperS.ofNull();
                    });
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

