/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.reports;

import cdm.event.common.Trade;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.SingleTradeLot;
import drr.regulation.techsprint.g20.mas.reports.ContractForEventRule;
import drr.regulation.techsprint.g20.mas.reports.IsFxPayoutRule;
import javax.inject.Inject;

@ImplementedBy(value=FXCurrency2RuleDefault.class)
public abstract class FXCurrency2Rule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected ContractForEventRule contractForEventRule;
    @Inject
    protected IsFxPayoutRule isFxPayoutRule;
    @Inject
    protected SingleTradeLot singleTradeLot;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class FXCurrency2RuleDefault
    extends FXCurrency2Rule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isFxPayoutRule.evaluate((TransactionReportInstruction)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.contractForEventRule.evaluate((TransactionReportInstruction)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.singleTradeLot.evaluate((Trade)item.get())));
            MapperC thenArg3 = thenArg2.mapSingleToList(item -> item.mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
            MapperC thenArg4 = thenArg3.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg5 = thenArg4.mapItem(item -> item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency()));
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg5.last().get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

