/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import cdm.product.asset.functions.ExtractFixedLeg;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.techsprint.g20.mas.reports.ContractForEventRule;
import drr.regulation.techsprint.g20.mas.reports.IsFixedFloatRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRatePayoutReceiverRuleDefault.class)
public abstract class InterestRatePayoutReceiverRule
implements ReportFunction<TransactionReportInstruction, Party> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ContractForEventRule contractForEventRule;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected ExtractFixedLeg extractFixedLeg;
    @Inject
    protected IsFixedFloatRule isFixedFloatRule;

    public Party evaluate(TransactionReportInstruction input) {
        Party output;
        Party.PartyBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract Party.PartyBuilder doEvaluate(TransactionReportInstruction var1);

    public static class InterestRatePayoutReceiverRuleDefault
    extends InterestRatePayoutReceiverRule {
        @Override
        protected Party.PartyBuilder doEvaluate(TransactionReportInstruction input) {
            Party.PartyBuilder output = Party.builder();
            return this.assignOutput(output, input);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)this.contractForEventRule.evaluate(input));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> this.isFixedFloatRule.evaluate((Trade)item.get()));
            ReferenceWithMetaParty referenceWithMetaParty = (ReferenceWithMetaParty)thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.extractCounterpartyByRole.evaluate(item.map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)this.extractFixedLeg.evaluate(item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).getMulti())).map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get())).map("getPartyReference", counterparty -> counterparty.getPartyReference())).get();
            output = referenceWithMetaParty == null ? null : (Party.PartyBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaParty.getValue());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

