/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.IsCapFloor;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CDEDirection1BuyerPartyDefault.class)
public abstract class CDEDirection1BuyerParty
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected IsCapFloor isCapFloor;
    @Inject
    protected IsCreditDefaultSwap isCreditDefaultSwap;
    @Inject
    protected IsVarianceSwap isVarianceSwap;
    @Inject
    protected IsVolatilitySwap isVolatilitySwap;

    public Party evaluate(Trade trade) {
        Party party;
        Party.PartyBuilder partyBuilder = this.doEvaluate(trade);
        if (partyBuilder == null) {
            party = null;
        } else {
            party = partyBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)party);
        }
        return party;
    }

    protected abstract Party.PartyBuilder doEvaluate(Trade var1);

    protected abstract MapperS<? extends Counterparty> counterparty(Trade var1);

    public static class CDEDirection1BuyerPartyDefault
    extends CDEDirection1BuyerParty {
        @Override
        protected Party.PartyBuilder doEvaluate(Trade trade) {
            Party.PartyBuilder party = Party.builder();
            return this.assignOutput(party, trade);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, Trade trade) {
            ReferenceWithMetaParty referenceWithMetaParty = (ReferenceWithMetaParty)this.counterparty(trade).map("getPartyReference", _counterparty -> _counterparty.getPartyReference()).get();
            party = referenceWithMetaParty == null ? null : (Party.PartyBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaParty.getValue());
            return Optional.ofNullable(party).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Counterparty> counterparty(Trade trade) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((OptionPayout)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getBuyerSeller", optionPayout -> optionPayout.getBuyerSeller()).map("getBuyer", buyerSeller -> buyerSeller.getBuyer()).get()));
            }
            Boolean boolean0 = this.isCreditDefaultSwap.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getPayerReceiver", creditDefaultPayout -> creditDefaultPayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isVarianceSwap.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isVolatilitySwap.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((PerformancePayout)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
            }
            Boolean boolean1 = this.isCapFloor.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get())).map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
            }
            return MapperS.ofNull();
        }
    }
}

