/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.functions;

import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.template.OptionPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=CDEEquityOptionNotionalDefault.class)
public abstract class CDEEquityOptionNotional
implements RosettaFunction {
    public BigDecimal evaluate(List<? extends OptionPayout> optionPayout) {
        BigDecimal amount = this.doEvaluate(optionPayout);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(List<? extends OptionPayout> var1);

    protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends OptionPayout> var1);

    protected abstract MapperS<BigDecimal> multipliedQuantity(List<? extends OptionPayout> var1);

    public static class CDEEquityOptionNotionalDefault
    extends CDEEquityOptionNotional {
        @Override
        protected BigDecimal doEvaluate(List<? extends OptionPayout> optionPayout) {
            if (optionPayout == null) {
                optionPayout = Collections.emptyList();
            }
            BigDecimal amount = null;
            return this.assignOutput(amount, optionPayout);
        }

        protected BigDecimal assignOutput(BigDecimal amount, List<? extends OptionPayout> optionPayout) {
            amount = ExpressionOperatorsNullSafe.exists((Mapper)this.quantity(optionPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)this.multipliedQuantity(optionPayout).get() : (ExpressionOperatorsNullSafe.exists((Mapper)this.quantity(optionPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)MapperMaths.multiply(this.multipliedQuantity(optionPayout), (Mapper)MapperC.of(optionPayout).map("getExerciseTerms", _optionPayout -> _optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getValue", price -> price.getValue())).get() : null);
            return amount;
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends OptionPayout> optionPayout) {
            return MapperS.of((Object)((OptionPayout)MapperC.of(optionPayout).get())).map("getPriceQuantity", _optionPayout -> _optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
        }

        @Override
        protected MapperS<BigDecimal> multipliedQuantity(List<? extends OptionPayout> optionPayout) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.quantity(optionPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperMaths.multiply((Mapper)this.quantity(optionPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)this.quantity(optionPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).map("getValue", measure -> measure.getValue()));
            }
            return this.quantity(optionPayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
        }
    }
}

