/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.event.common.Trade;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.template.EconomicTerms;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.IsEquityOption;
import drr.regulation.common.functions.ProductForTrade;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=CDENotionalRuleDefault.class)
public abstract class CDENotionalRule
implements ReportFunction<Trade, BigDecimal> {
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected IsEquityOption isEquityOption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;

    public BigDecimal evaluate(Trade input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(Trade var1);

    public static class CDENotionalRuleDefault
    extends CDENotionalRule {
        @Override
        protected BigDecimal doEvaluate(Trade input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, Trade input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())));
            output = (BigDecimal)thenArg.mapSingleToItem(product -> {
                MapperS _thenArg = thenArg.map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
                return _thenArg.mapSingleToItem(item -> {
                    if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)((OptionPayout)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
                    }
                    if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
                    }
                    Boolean boolean0 = this.qualify_Commodity_Swap_FixedFloat.evaluate((EconomicTerms)item.get());
                    if (boolean0 != null && boolean0.booleanValue()) {
                        return MapperMaths.multiply((Mapper)MapperS.of((Object)this.commodityLeg2.evaluate((Product)product.get())).map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)MapperS.of((Object)this.fixedPriceLeg1.evaluate((Product)product.get())).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()));
                    }
                    Boolean boolean1 = this.qualify_Commodity_Option.evaluate((EconomicTerms)item.get());
                    if (boolean1 != null && boolean1.booleanValue()) {
                        return MapperMaths.multiply((Mapper)MapperS.of((Object)((OptionPayout)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getValue", price -> price.getValue()), (Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
                    }
                    Boolean boolean2 = this.isEquityOption.evaluate((Product)product.get());
                    if (boolean2 != null && boolean2.booleanValue()) {
                        return MapperMaths.multiply((Mapper)MapperS.of((Object)((OptionPayout)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getValue", price -> price.getValue()), (Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
                    }
                    return MapperS.ofNull();
                });
            }).get();
            return output;
        }
    }
}

