/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.IsCallOption;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.IsPutOption;
import javax.inject.Inject;

@ImplementedBy(value=UPIOptionTypeRuleDefault.class)
public abstract class UPIOptionTypeRule
implements ReportFunction<Product, String> {
    @Inject
    protected IsCallOption isCallOption;
    @Inject
    protected IsCap isCap;
    @Inject
    protected IsFloor isFloor;
    @Inject
    protected IsOption isOption;
    @Inject
    protected IsPutOption isPutOption;

    public String evaluate(Product input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(Product var1);

    public static class UPIOptionTypeRuleDefault
    extends UPIOptionTypeRule {
        @Override
        protected String doEvaluate(Product input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, Product input) {
            output = (String)MapperS.of((Object)input).mapSingleToItem(item -> {
                if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isPutOption.evaluate((Product)item.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFloor.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)"PUTO");
                }
                if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCallOption.evaluate((Product)item.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCap.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)"CALL");
                }
                Boolean _boolean = this.isOption.evaluate((Product)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)"OTHR");
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

