/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.upi;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.standards.iso.upi.AnnaDsbCFIDeliveryTypeEnum;
import drr.standards.iso.upi.AnnaDsbCFIOptionStyleandTypeEnum;
import drr.standards.iso.upi.AnnaDsbDeliveryTypeEnum;
import drr.standards.iso.upi.AnnaDsbOptionExerciseStyleEnum;
import drr.standards.iso.upi.AnnaDsbReturnorPayoutTriggerEnum;
import drr.standards.iso.upi.AnnaDsbSingleorMultiCurrencyEnum;
import drr.standards.iso.upi.AnnaDsbUnderlyingAssetClass;
import drr.standards.iso.upi.AnnaDsbUnderlyingIssuerTypeEnum;
import drr.standards.iso.upi.AnnaDsbUnderlyingRecord;
import drr.standards.iso.upi.AnnaDsbValuationMethodorTriggerEnum;
import drr.standards.iso.upi.meta.AnnaDsbDerivedMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AnnaDsbDerived", builder=AnnaDsbDerivedBuilderImpl.class, version="5.55.0")
@RuneDataType(value="AnnaDsbDerived", model="drr", builder=AnnaDsbDerivedBuilderImpl.class, version="5.55.0")
public interface AnnaDsbDerived
extends RosettaModelObject {
    public static final AnnaDsbDerivedMeta metaData = new AnnaDsbDerivedMeta();

    public AnnaDsbReturnorPayoutTriggerEnum getReturnorPayoutTrigger();

    public String getUnderlierCharacteristic();

    public AnnaDsbValuationMethodorTriggerEnum getValuationMethodorTrigger();

    public String getShortName();

    public AnnaDsbUnderlyingIssuerTypeEnum getUnderlyingIssuerType();

    public String getClassificationType();

    public AnnaDsbOptionExerciseStyleEnum getOptionExerciseStyle();

    public String getUnderlyingAssetType();

    public AnnaDsbSingleorMultiCurrencyEnum getSingleorMultiCurrency();

    public AnnaDsbCFIDeliveryTypeEnum getCFIDeliveryType();

    public List<? extends AnnaDsbUnderlyingRecord> getUnderlyingRecord();

    public AnnaDsbCFIOptionStyleandTypeEnum getCFIOptionStyleandType();

    public String getUnderlierName();

    public AnnaDsbUnderlyingAssetClass getUnderlyingAssetClass();

    public AnnaDsbDeliveryTypeEnum getDeliveryType();

    public String getFurtherGrouping();

    public AnnaDsbDerived build();

    public AnnaDsbDerivedBuilder toBuilder();

    public static AnnaDsbDerivedBuilder builder() {
        return new AnnaDsbDerivedBuilderImpl();
    }

    default public RosettaMetaData<? extends AnnaDsbDerived> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AnnaDsbDerived> getType() {
        return AnnaDsbDerived.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("ReturnorPayoutTrigger"), AnnaDsbReturnorPayoutTriggerEnum.class, (Object)this.getReturnorPayoutTrigger(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("UnderlierCharacteristic"), String.class, (Object)this.getUnderlierCharacteristic(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ValuationMethodorTrigger"), AnnaDsbValuationMethodorTriggerEnum.class, (Object)this.getValuationMethodorTrigger(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ShortName"), String.class, (Object)this.getShortName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("UnderlyingIssuerType"), AnnaDsbUnderlyingIssuerTypeEnum.class, (Object)this.getUnderlyingIssuerType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ClassificationType"), String.class, (Object)this.getClassificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("OptionExerciseStyle"), AnnaDsbOptionExerciseStyleEnum.class, (Object)this.getOptionExerciseStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("UnderlyingAssetType"), String.class, (Object)this.getUnderlyingAssetType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("SingleorMultiCurrency"), AnnaDsbSingleorMultiCurrencyEnum.class, (Object)this.getSingleorMultiCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("CFIDeliveryType"), AnnaDsbCFIDeliveryTypeEnum.class, (Object)this.getCFIDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("UnderlyingRecord"), processor, AnnaDsbUnderlyingRecord.class, this.getUnderlyingRecord(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("CFIOptionStyleandType"), AnnaDsbCFIOptionStyleandTypeEnum.class, (Object)this.getCFIOptionStyleandType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("UnderlierName"), String.class, (Object)this.getUnderlierName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("UnderlyingAssetClass"), processor, AnnaDsbUnderlyingAssetClass.class, this.getUnderlyingAssetClass(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("DeliveryType"), AnnaDsbDeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("FurtherGrouping"), String.class, (Object)this.getFurtherGrouping(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AnnaDsbDerivedBuilderImpl
    implements AnnaDsbDerivedBuilder {
        protected AnnaDsbReturnorPayoutTriggerEnum returnorPayoutTrigger;
        protected String underlierCharacteristic;
        protected AnnaDsbValuationMethodorTriggerEnum valuationMethodorTrigger;
        protected String shortName;
        protected AnnaDsbUnderlyingIssuerTypeEnum underlyingIssuerType;
        protected String classificationType;
        protected AnnaDsbOptionExerciseStyleEnum optionExerciseStyle;
        protected String underlyingAssetType;
        protected AnnaDsbSingleorMultiCurrencyEnum singleorMultiCurrency;
        protected AnnaDsbCFIDeliveryTypeEnum cFIDeliveryType;
        protected List<AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder> underlyingRecord = new ArrayList<AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder>();
        protected AnnaDsbCFIOptionStyleandTypeEnum cFIOptionStyleandType;
        protected String underlierName;
        protected AnnaDsbUnderlyingAssetClass.AnnaDsbUnderlyingAssetClassBuilder underlyingAssetClass;
        protected AnnaDsbDeliveryTypeEnum deliveryType;
        protected String furtherGrouping;

        @Override
        @RosettaAttribute(value="ReturnorPayoutTrigger")
        @RuneAttribute(value="ReturnorPayoutTrigger")
        public AnnaDsbReturnorPayoutTriggerEnum getReturnorPayoutTrigger() {
            return this.returnorPayoutTrigger;
        }

        @Override
        @RosettaAttribute(value="UnderlierCharacteristic")
        @RuneAttribute(value="UnderlierCharacteristic")
        public String getUnderlierCharacteristic() {
            return this.underlierCharacteristic;
        }

        @Override
        @RosettaAttribute(value="ValuationMethodorTrigger")
        @RuneAttribute(value="ValuationMethodorTrigger")
        public AnnaDsbValuationMethodorTriggerEnum getValuationMethodorTrigger() {
            return this.valuationMethodorTrigger;
        }

        @Override
        @RosettaAttribute(value="ShortName", isRequired=true)
        @RuneAttribute(value="ShortName", isRequired=true)
        public String getShortName() {
            return this.shortName;
        }

        @Override
        @RosettaAttribute(value="UnderlyingIssuerType")
        @RuneAttribute(value="UnderlyingIssuerType")
        public AnnaDsbUnderlyingIssuerTypeEnum getUnderlyingIssuerType() {
            return this.underlyingIssuerType;
        }

        @Override
        @RosettaAttribute(value="ClassificationType", isRequired=true)
        @RuneAttribute(value="ClassificationType", isRequired=true)
        public String getClassificationType() {
            return this.classificationType;
        }

        @Override
        @RosettaAttribute(value="OptionExerciseStyle")
        @RuneAttribute(value="OptionExerciseStyle")
        public AnnaDsbOptionExerciseStyleEnum getOptionExerciseStyle() {
            return this.optionExerciseStyle;
        }

        @Override
        @RosettaAttribute(value="UnderlyingAssetType")
        @RuneAttribute(value="UnderlyingAssetType")
        public String getUnderlyingAssetType() {
            return this.underlyingAssetType;
        }

        @Override
        @RosettaAttribute(value="SingleorMultiCurrency")
        @RuneAttribute(value="SingleorMultiCurrency")
        public AnnaDsbSingleorMultiCurrencyEnum getSingleorMultiCurrency() {
            return this.singleorMultiCurrency;
        }

        @Override
        @RosettaAttribute(value="CFIDeliveryType")
        @RuneAttribute(value="CFIDeliveryType")
        public AnnaDsbCFIDeliveryTypeEnum getCFIDeliveryType() {
            return this.cFIDeliveryType;
        }

        @Override
        @RosettaAttribute(value="UnderlyingRecord")
        @RuneAttribute(value="UnderlyingRecord")
        public List<? extends AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder> getUnderlyingRecord() {
            return this.underlyingRecord;
        }

        @Override
        public AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder getOrCreateUnderlyingRecord(int index) {
            if (this.underlyingRecord == null) {
                this.underlyingRecord = new ArrayList<AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder>();
            }
            return (AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder)this.getIndex(this.underlyingRecord, index, () -> {
                AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder newUnderlyingRecord = AnnaDsbUnderlyingRecord.builder();
                return newUnderlyingRecord;
            });
        }

        @Override
        @RosettaAttribute(value="CFIOptionStyleandType")
        @RuneAttribute(value="CFIOptionStyleandType")
        public AnnaDsbCFIOptionStyleandTypeEnum getCFIOptionStyleandType() {
            return this.cFIOptionStyleandType;
        }

        @Override
        @RosettaAttribute(value="UnderlierName")
        @RuneAttribute(value="UnderlierName")
        public String getUnderlierName() {
            return this.underlierName;
        }

        @Override
        @RosettaAttribute(value="UnderlyingAssetClass")
        @RuneAttribute(value="UnderlyingAssetClass")
        public AnnaDsbUnderlyingAssetClass.AnnaDsbUnderlyingAssetClassBuilder getUnderlyingAssetClass() {
            return this.underlyingAssetClass;
        }

        @Override
        public AnnaDsbUnderlyingAssetClass.AnnaDsbUnderlyingAssetClassBuilder getOrCreateUnderlyingAssetClass() {
            AnnaDsbUnderlyingAssetClass.AnnaDsbUnderlyingAssetClassBuilder result = this.underlyingAssetClass != null ? this.underlyingAssetClass : (this.underlyingAssetClass = AnnaDsbUnderlyingAssetClass.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="DeliveryType")
        @RuneAttribute(value="DeliveryType")
        public AnnaDsbDeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="FurtherGrouping")
        @RuneAttribute(value="FurtherGrouping")
        public String getFurtherGrouping() {
            return this.furtherGrouping;
        }

        @Override
        @RosettaAttribute(value="ReturnorPayoutTrigger")
        @RuneAttribute(value="ReturnorPayoutTrigger")
        public AnnaDsbDerivedBuilder setReturnorPayoutTrigger(AnnaDsbReturnorPayoutTriggerEnum _returnorPayoutTrigger) {
            this.returnorPayoutTrigger = _returnorPayoutTrigger == null ? null : _returnorPayoutTrigger;
            return this;
        }

        @Override
        @RosettaAttribute(value="UnderlierCharacteristic")
        @RuneAttribute(value="UnderlierCharacteristic")
        public AnnaDsbDerivedBuilder setUnderlierCharacteristic(String _underlierCharacteristic) {
            this.underlierCharacteristic = _underlierCharacteristic == null ? null : _underlierCharacteristic;
            return this;
        }

        @Override
        @RosettaAttribute(value="ValuationMethodorTrigger")
        @RuneAttribute(value="ValuationMethodorTrigger")
        public AnnaDsbDerivedBuilder setValuationMethodorTrigger(AnnaDsbValuationMethodorTriggerEnum _valuationMethodorTrigger) {
            this.valuationMethodorTrigger = _valuationMethodorTrigger == null ? null : _valuationMethodorTrigger;
            return this;
        }

        @Override
        @RosettaAttribute(value="ShortName", isRequired=true)
        @RuneAttribute(value="ShortName", isRequired=true)
        public AnnaDsbDerivedBuilder setShortName(String _shortName) {
            this.shortName = _shortName == null ? null : _shortName;
            return this;
        }

        @Override
        @RosettaAttribute(value="UnderlyingIssuerType")
        @RuneAttribute(value="UnderlyingIssuerType")
        public AnnaDsbDerivedBuilder setUnderlyingIssuerType(AnnaDsbUnderlyingIssuerTypeEnum _underlyingIssuerType) {
            this.underlyingIssuerType = _underlyingIssuerType == null ? null : _underlyingIssuerType;
            return this;
        }

        @Override
        @RosettaAttribute(value="ClassificationType", isRequired=true)
        @RuneAttribute(value="ClassificationType", isRequired=true)
        public AnnaDsbDerivedBuilder setClassificationType(String _classificationType) {
            this.classificationType = _classificationType == null ? null : _classificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="OptionExerciseStyle")
        @RuneAttribute(value="OptionExerciseStyle")
        public AnnaDsbDerivedBuilder setOptionExerciseStyle(AnnaDsbOptionExerciseStyleEnum _optionExerciseStyle) {
            this.optionExerciseStyle = _optionExerciseStyle == null ? null : _optionExerciseStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="UnderlyingAssetType")
        @RuneAttribute(value="UnderlyingAssetType")
        public AnnaDsbDerivedBuilder setUnderlyingAssetType(String _underlyingAssetType) {
            this.underlyingAssetType = _underlyingAssetType == null ? null : _underlyingAssetType;
            return this;
        }

        @Override
        @RosettaAttribute(value="SingleorMultiCurrency")
        @RuneAttribute(value="SingleorMultiCurrency")
        public AnnaDsbDerivedBuilder setSingleorMultiCurrency(AnnaDsbSingleorMultiCurrencyEnum _singleorMultiCurrency) {
            this.singleorMultiCurrency = _singleorMultiCurrency == null ? null : _singleorMultiCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="CFIDeliveryType")
        @RuneAttribute(value="CFIDeliveryType")
        public AnnaDsbDerivedBuilder setCFIDeliveryType(AnnaDsbCFIDeliveryTypeEnum _cFIDeliveryType) {
            this.cFIDeliveryType = _cFIDeliveryType == null ? null : _cFIDeliveryType;
            return this;
        }

        @Override
        @RosettaAttribute(value="UnderlyingRecord")
        @RuneAttribute(value="UnderlyingRecord")
        public AnnaDsbDerivedBuilder addUnderlyingRecord(AnnaDsbUnderlyingRecord _underlyingRecord) {
            if (_underlyingRecord != null) {
                this.underlyingRecord.add(_underlyingRecord.toBuilder());
            }
            return this;
        }

        @Override
        public AnnaDsbDerivedBuilder addUnderlyingRecord(AnnaDsbUnderlyingRecord _underlyingRecord, int idx) {
            this.getIndex(this.underlyingRecord, idx, () -> _underlyingRecord.toBuilder());
            return this;
        }

        @Override
        public AnnaDsbDerivedBuilder addUnderlyingRecord(List<? extends AnnaDsbUnderlyingRecord> underlyingRecords) {
            if (underlyingRecords != null) {
                for (AnnaDsbUnderlyingRecord annaDsbUnderlyingRecord : underlyingRecords) {
                    this.underlyingRecord.add(annaDsbUnderlyingRecord.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="UnderlyingRecord")
        public AnnaDsbDerivedBuilder setUnderlyingRecord(List<? extends AnnaDsbUnderlyingRecord> underlyingRecords) {
            this.underlyingRecord = underlyingRecords == null ? new ArrayList<AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder>() : (List)underlyingRecords.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="CFIOptionStyleandType")
        @RuneAttribute(value="CFIOptionStyleandType")
        public AnnaDsbDerivedBuilder setCFIOptionStyleandType(AnnaDsbCFIOptionStyleandTypeEnum _cFIOptionStyleandType) {
            this.cFIOptionStyleandType = _cFIOptionStyleandType == null ? null : _cFIOptionStyleandType;
            return this;
        }

        @Override
        @RosettaAttribute(value="UnderlierName")
        @RuneAttribute(value="UnderlierName")
        public AnnaDsbDerivedBuilder setUnderlierName(String _underlierName) {
            this.underlierName = _underlierName == null ? null : _underlierName;
            return this;
        }

        @Override
        @RosettaAttribute(value="UnderlyingAssetClass")
        @RuneAttribute(value="UnderlyingAssetClass")
        public AnnaDsbDerivedBuilder setUnderlyingAssetClass(AnnaDsbUnderlyingAssetClass _underlyingAssetClass) {
            this.underlyingAssetClass = _underlyingAssetClass == null ? null : _underlyingAssetClass.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="DeliveryType")
        @RuneAttribute(value="DeliveryType")
        public AnnaDsbDerivedBuilder setDeliveryType(AnnaDsbDeliveryTypeEnum _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaAttribute(value="FurtherGrouping")
        @RuneAttribute(value="FurtherGrouping")
        public AnnaDsbDerivedBuilder setFurtherGrouping(String _furtherGrouping) {
            this.furtherGrouping = _furtherGrouping == null ? null : _furtherGrouping;
            return this;
        }

        @Override
        public AnnaDsbDerived build() {
            return new AnnaDsbDerivedImpl(this);
        }

        @Override
        public AnnaDsbDerivedBuilder toBuilder() {
            return this;
        }

        @Override
        public AnnaDsbDerivedBuilder prune() {
            this.underlyingRecord = this.underlyingRecord.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.underlyingAssetClass != null && !this.underlyingAssetClass.prune().hasData()) {
                this.underlyingAssetClass = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getReturnorPayoutTrigger() != null) {
                return true;
            }
            if (this.getUnderlierCharacteristic() != null) {
                return true;
            }
            if (this.getValuationMethodorTrigger() != null) {
                return true;
            }
            if (this.getShortName() != null) {
                return true;
            }
            if (this.getUnderlyingIssuerType() != null) {
                return true;
            }
            if (this.getClassificationType() != null) {
                return true;
            }
            if (this.getOptionExerciseStyle() != null) {
                return true;
            }
            if (this.getUnderlyingAssetType() != null) {
                return true;
            }
            if (this.getSingleorMultiCurrency() != null) {
                return true;
            }
            if (this.getCFIDeliveryType() != null) {
                return true;
            }
            if (this.getUnderlyingRecord() != null && this.getUnderlyingRecord().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCFIOptionStyleandType() != null) {
                return true;
            }
            if (this.getUnderlierName() != null) {
                return true;
            }
            if (this.getUnderlyingAssetClass() != null && this.getUnderlyingAssetClass().hasData()) {
                return true;
            }
            if (this.getDeliveryType() != null) {
                return true;
            }
            return this.getFurtherGrouping() != null;
        }

        public AnnaDsbDerivedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AnnaDsbDerivedBuilder o = (AnnaDsbDerivedBuilder)other;
            merger.mergeRosetta(this.getUnderlyingRecord(), o.getUnderlyingRecord(), this::getOrCreateUnderlyingRecord);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingAssetClass(), (RosettaModelObjectBuilder)o.getUnderlyingAssetClass(), this::setUnderlyingAssetClass);
            merger.mergeBasic((Object)this.getReturnorPayoutTrigger(), (Object)o.getReturnorPayoutTrigger(), this::setReturnorPayoutTrigger, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlierCharacteristic(), (Object)o.getUnderlierCharacteristic(), this::setUnderlierCharacteristic, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethodorTrigger(), (Object)o.getValuationMethodorTrigger(), this::setValuationMethodorTrigger, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getShortName(), (Object)o.getShortName(), this::setShortName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIssuerType(), (Object)o.getUnderlyingIssuerType(), this::setUnderlyingIssuerType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClassificationType(), (Object)o.getClassificationType(), this::setClassificationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionExerciseStyle(), (Object)o.getOptionExerciseStyle(), this::setOptionExerciseStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingAssetType(), (Object)o.getUnderlyingAssetType(), this::setUnderlyingAssetType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSingleorMultiCurrency(), (Object)o.getSingleorMultiCurrency(), this::setSingleorMultiCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCFIDeliveryType(), (Object)o.getCFIDeliveryType(), this::setCFIDeliveryType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCFIOptionStyleandType(), (Object)o.getCFIOptionStyleandType(), this::setCFIOptionStyleandType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlierName(), (Object)o.getUnderlierName(), this::setUnderlierName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryType(), (Object)o.getDeliveryType(), this::setDeliveryType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFurtherGrouping(), (Object)o.getFurtherGrouping(), this::setFurtherGrouping, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AnnaDsbDerived _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.returnorPayoutTrigger, (Object)_that.getReturnorPayoutTrigger())) {
                return false;
            }
            if (!Objects.equals(this.underlierCharacteristic, _that.getUnderlierCharacteristic())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethodorTrigger, (Object)_that.getValuationMethodorTrigger())) {
                return false;
            }
            if (!Objects.equals(this.shortName, _that.getShortName())) {
                return false;
            }
            if (!Objects.equals((Object)this.underlyingIssuerType, (Object)_that.getUnderlyingIssuerType())) {
                return false;
            }
            if (!Objects.equals(this.classificationType, _that.getClassificationType())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionExerciseStyle, (Object)_that.getOptionExerciseStyle())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetType, _that.getUnderlyingAssetType())) {
                return false;
            }
            if (!Objects.equals((Object)this.singleorMultiCurrency, (Object)_that.getSingleorMultiCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.cFIDeliveryType, (Object)_that.getCFIDeliveryType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyingRecord, _that.getUnderlyingRecord())) {
                return false;
            }
            if (!Objects.equals((Object)this.cFIOptionStyleandType, (Object)_that.getCFIOptionStyleandType())) {
                return false;
            }
            if (!Objects.equals(this.underlierName, _that.getUnderlierName())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetClass, _that.getUnderlyingAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType())) {
                return false;
            }
            return Objects.equals(this.furtherGrouping, _that.getFurtherGrouping());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.returnorPayoutTrigger != null ? ((Object)((Object)this.returnorPayoutTrigger)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlierCharacteristic != null ? this.underlierCharacteristic.hashCode() : 0);
            _result = 31 * _result + (this.valuationMethodorTrigger != null ? ((Object)((Object)this.valuationMethodorTrigger)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.shortName != null ? this.shortName.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIssuerType != null ? ((Object)((Object)this.underlyingIssuerType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.classificationType != null ? this.classificationType.hashCode() : 0);
            _result = 31 * _result + (this.optionExerciseStyle != null ? ((Object)((Object)this.optionExerciseStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetType != null ? this.underlyingAssetType.hashCode() : 0);
            _result = 31 * _result + (this.singleorMultiCurrency != null ? ((Object)((Object)this.singleorMultiCurrency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cFIDeliveryType != null ? ((Object)((Object)this.cFIDeliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingRecord != null ? this.underlyingRecord.hashCode() : 0);
            _result = 31 * _result + (this.cFIOptionStyleandType != null ? ((Object)((Object)this.cFIOptionStyleandType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlierName != null ? this.underlierName.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetClass != null ? this.underlyingAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.furtherGrouping != null ? this.furtherGrouping.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AnnaDsbDerivedBuilder {ReturnorPayoutTrigger=" + String.valueOf((Object)this.returnorPayoutTrigger) + ", UnderlierCharacteristic=" + this.underlierCharacteristic + ", ValuationMethodorTrigger=" + String.valueOf((Object)this.valuationMethodorTrigger) + ", ShortName=" + this.shortName + ", UnderlyingIssuerType=" + String.valueOf((Object)this.underlyingIssuerType) + ", ClassificationType=" + this.classificationType + ", OptionExerciseStyle=" + String.valueOf((Object)this.optionExerciseStyle) + ", UnderlyingAssetType=" + this.underlyingAssetType + ", SingleorMultiCurrency=" + String.valueOf((Object)this.singleorMultiCurrency) + ", CFIDeliveryType=" + String.valueOf((Object)this.cFIDeliveryType) + ", UnderlyingRecord=" + String.valueOf(this.underlyingRecord) + ", CFIOptionStyleandType=" + String.valueOf((Object)this.cFIOptionStyleandType) + ", UnderlierName=" + this.underlierName + ", UnderlyingAssetClass=" + String.valueOf(this.underlyingAssetClass) + ", DeliveryType=" + String.valueOf((Object)this.deliveryType) + ", FurtherGrouping=" + this.furtherGrouping + "}";
        }
    }

    public static interface AnnaDsbDerivedBuilder
    extends AnnaDsbDerived,
    RosettaModelObjectBuilder {
        public AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder getOrCreateUnderlyingRecord(int var1);

        public List<? extends AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder> getUnderlyingRecord();

        public AnnaDsbUnderlyingAssetClass.AnnaDsbUnderlyingAssetClassBuilder getOrCreateUnderlyingAssetClass();

        @Override
        public AnnaDsbUnderlyingAssetClass.AnnaDsbUnderlyingAssetClassBuilder getUnderlyingAssetClass();

        public AnnaDsbDerivedBuilder setReturnorPayoutTrigger(AnnaDsbReturnorPayoutTriggerEnum var1);

        public AnnaDsbDerivedBuilder setUnderlierCharacteristic(String var1);

        public AnnaDsbDerivedBuilder setValuationMethodorTrigger(AnnaDsbValuationMethodorTriggerEnum var1);

        public AnnaDsbDerivedBuilder setShortName(String var1);

        public AnnaDsbDerivedBuilder setUnderlyingIssuerType(AnnaDsbUnderlyingIssuerTypeEnum var1);

        public AnnaDsbDerivedBuilder setClassificationType(String var1);

        public AnnaDsbDerivedBuilder setOptionExerciseStyle(AnnaDsbOptionExerciseStyleEnum var1);

        public AnnaDsbDerivedBuilder setUnderlyingAssetType(String var1);

        public AnnaDsbDerivedBuilder setSingleorMultiCurrency(AnnaDsbSingleorMultiCurrencyEnum var1);

        public AnnaDsbDerivedBuilder setCFIDeliveryType(AnnaDsbCFIDeliveryTypeEnum var1);

        public AnnaDsbDerivedBuilder addUnderlyingRecord(AnnaDsbUnderlyingRecord var1);

        public AnnaDsbDerivedBuilder addUnderlyingRecord(AnnaDsbUnderlyingRecord var1, int var2);

        public AnnaDsbDerivedBuilder addUnderlyingRecord(List<? extends AnnaDsbUnderlyingRecord> var1);

        public AnnaDsbDerivedBuilder setUnderlyingRecord(List<? extends AnnaDsbUnderlyingRecord> var1);

        public AnnaDsbDerivedBuilder setCFIOptionStyleandType(AnnaDsbCFIOptionStyleandTypeEnum var1);

        public AnnaDsbDerivedBuilder setUnderlierName(String var1);

        public AnnaDsbDerivedBuilder setUnderlyingAssetClass(AnnaDsbUnderlyingAssetClass var1);

        public AnnaDsbDerivedBuilder setDeliveryType(AnnaDsbDeliveryTypeEnum var1);

        public AnnaDsbDerivedBuilder setFurtherGrouping(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("ReturnorPayoutTrigger"), AnnaDsbReturnorPayoutTriggerEnum.class, (Object)this.getReturnorPayoutTrigger(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("UnderlierCharacteristic"), String.class, (Object)this.getUnderlierCharacteristic(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ValuationMethodorTrigger"), AnnaDsbValuationMethodorTriggerEnum.class, (Object)this.getValuationMethodorTrigger(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ShortName"), String.class, (Object)this.getShortName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("UnderlyingIssuerType"), AnnaDsbUnderlyingIssuerTypeEnum.class, (Object)this.getUnderlyingIssuerType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ClassificationType"), String.class, (Object)this.getClassificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("OptionExerciseStyle"), AnnaDsbOptionExerciseStyleEnum.class, (Object)this.getOptionExerciseStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("UnderlyingAssetType"), String.class, (Object)this.getUnderlyingAssetType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("SingleorMultiCurrency"), AnnaDsbSingleorMultiCurrencyEnum.class, (Object)this.getSingleorMultiCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("CFIDeliveryType"), AnnaDsbCFIDeliveryTypeEnum.class, (Object)this.getCFIDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("UnderlyingRecord"), processor, AnnaDsbUnderlyingRecord.AnnaDsbUnderlyingRecordBuilder.class, this.getUnderlyingRecord(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("CFIOptionStyleandType"), AnnaDsbCFIOptionStyleandTypeEnum.class, (Object)this.getCFIOptionStyleandType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("UnderlierName"), String.class, (Object)this.getUnderlierName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("UnderlyingAssetClass"), processor, AnnaDsbUnderlyingAssetClass.AnnaDsbUnderlyingAssetClassBuilder.class, this.getUnderlyingAssetClass(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("DeliveryType"), AnnaDsbDeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("FurtherGrouping"), String.class, (Object)this.getFurtherGrouping(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AnnaDsbDerivedBuilder prune();
    }

    public static class AnnaDsbDerivedImpl
    implements AnnaDsbDerived {
        private final AnnaDsbReturnorPayoutTriggerEnum returnorPayoutTrigger;
        private final String underlierCharacteristic;
        private final AnnaDsbValuationMethodorTriggerEnum valuationMethodorTrigger;
        private final String shortName;
        private final AnnaDsbUnderlyingIssuerTypeEnum underlyingIssuerType;
        private final String classificationType;
        private final AnnaDsbOptionExerciseStyleEnum optionExerciseStyle;
        private final String underlyingAssetType;
        private final AnnaDsbSingleorMultiCurrencyEnum singleorMultiCurrency;
        private final AnnaDsbCFIDeliveryTypeEnum cFIDeliveryType;
        private final List<? extends AnnaDsbUnderlyingRecord> underlyingRecord;
        private final AnnaDsbCFIOptionStyleandTypeEnum cFIOptionStyleandType;
        private final String underlierName;
        private final AnnaDsbUnderlyingAssetClass underlyingAssetClass;
        private final AnnaDsbDeliveryTypeEnum deliveryType;
        private final String furtherGrouping;

        protected AnnaDsbDerivedImpl(AnnaDsbDerivedBuilder builder) {
            this.returnorPayoutTrigger = builder.getReturnorPayoutTrigger();
            this.underlierCharacteristic = builder.getUnderlierCharacteristic();
            this.valuationMethodorTrigger = builder.getValuationMethodorTrigger();
            this.shortName = builder.getShortName();
            this.underlyingIssuerType = builder.getUnderlyingIssuerType();
            this.classificationType = builder.getClassificationType();
            this.optionExerciseStyle = builder.getOptionExerciseStyle();
            this.underlyingAssetType = builder.getUnderlyingAssetType();
            this.singleorMultiCurrency = builder.getSingleorMultiCurrency();
            this.cFIDeliveryType = builder.getCFIDeliveryType();
            this.underlyingRecord = Optional.ofNullable(builder.getUnderlyingRecord()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.cFIOptionStyleandType = builder.getCFIOptionStyleandType();
            this.underlierName = builder.getUnderlierName();
            this.underlyingAssetClass = Optional.ofNullable(builder.getUnderlyingAssetClass()).map(f -> f.build()).orElse(null);
            this.deliveryType = builder.getDeliveryType();
            this.furtherGrouping = builder.getFurtherGrouping();
        }

        @Override
        @RosettaAttribute(value="ReturnorPayoutTrigger")
        @RuneAttribute(value="ReturnorPayoutTrigger")
        public AnnaDsbReturnorPayoutTriggerEnum getReturnorPayoutTrigger() {
            return this.returnorPayoutTrigger;
        }

        @Override
        @RosettaAttribute(value="UnderlierCharacteristic")
        @RuneAttribute(value="UnderlierCharacteristic")
        public String getUnderlierCharacteristic() {
            return this.underlierCharacteristic;
        }

        @Override
        @RosettaAttribute(value="ValuationMethodorTrigger")
        @RuneAttribute(value="ValuationMethodorTrigger")
        public AnnaDsbValuationMethodorTriggerEnum getValuationMethodorTrigger() {
            return this.valuationMethodorTrigger;
        }

        @Override
        @RosettaAttribute(value="ShortName", isRequired=true)
        @RuneAttribute(value="ShortName", isRequired=true)
        public String getShortName() {
            return this.shortName;
        }

        @Override
        @RosettaAttribute(value="UnderlyingIssuerType")
        @RuneAttribute(value="UnderlyingIssuerType")
        public AnnaDsbUnderlyingIssuerTypeEnum getUnderlyingIssuerType() {
            return this.underlyingIssuerType;
        }

        @Override
        @RosettaAttribute(value="ClassificationType", isRequired=true)
        @RuneAttribute(value="ClassificationType", isRequired=true)
        public String getClassificationType() {
            return this.classificationType;
        }

        @Override
        @RosettaAttribute(value="OptionExerciseStyle")
        @RuneAttribute(value="OptionExerciseStyle")
        public AnnaDsbOptionExerciseStyleEnum getOptionExerciseStyle() {
            return this.optionExerciseStyle;
        }

        @Override
        @RosettaAttribute(value="UnderlyingAssetType")
        @RuneAttribute(value="UnderlyingAssetType")
        public String getUnderlyingAssetType() {
            return this.underlyingAssetType;
        }

        @Override
        @RosettaAttribute(value="SingleorMultiCurrency")
        @RuneAttribute(value="SingleorMultiCurrency")
        public AnnaDsbSingleorMultiCurrencyEnum getSingleorMultiCurrency() {
            return this.singleorMultiCurrency;
        }

        @Override
        @RosettaAttribute(value="CFIDeliveryType")
        @RuneAttribute(value="CFIDeliveryType")
        public AnnaDsbCFIDeliveryTypeEnum getCFIDeliveryType() {
            return this.cFIDeliveryType;
        }

        @Override
        @RosettaAttribute(value="UnderlyingRecord")
        @RuneAttribute(value="UnderlyingRecord")
        public List<? extends AnnaDsbUnderlyingRecord> getUnderlyingRecord() {
            return this.underlyingRecord;
        }

        @Override
        @RosettaAttribute(value="CFIOptionStyleandType")
        @RuneAttribute(value="CFIOptionStyleandType")
        public AnnaDsbCFIOptionStyleandTypeEnum getCFIOptionStyleandType() {
            return this.cFIOptionStyleandType;
        }

        @Override
        @RosettaAttribute(value="UnderlierName")
        @RuneAttribute(value="UnderlierName")
        public String getUnderlierName() {
            return this.underlierName;
        }

        @Override
        @RosettaAttribute(value="UnderlyingAssetClass")
        @RuneAttribute(value="UnderlyingAssetClass")
        public AnnaDsbUnderlyingAssetClass getUnderlyingAssetClass() {
            return this.underlyingAssetClass;
        }

        @Override
        @RosettaAttribute(value="DeliveryType")
        @RuneAttribute(value="DeliveryType")
        public AnnaDsbDeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="FurtherGrouping")
        @RuneAttribute(value="FurtherGrouping")
        public String getFurtherGrouping() {
            return this.furtherGrouping;
        }

        @Override
        public AnnaDsbDerived build() {
            return this;
        }

        @Override
        public AnnaDsbDerivedBuilder toBuilder() {
            AnnaDsbDerivedBuilder builder = AnnaDsbDerived.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AnnaDsbDerivedBuilder builder) {
            Optional.ofNullable(this.getReturnorPayoutTrigger()).ifPresent(builder::setReturnorPayoutTrigger);
            Optional.ofNullable(this.getUnderlierCharacteristic()).ifPresent(builder::setUnderlierCharacteristic);
            Optional.ofNullable(this.getValuationMethodorTrigger()).ifPresent(builder::setValuationMethodorTrigger);
            Optional.ofNullable(this.getShortName()).ifPresent(builder::setShortName);
            Optional.ofNullable(this.getUnderlyingIssuerType()).ifPresent(builder::setUnderlyingIssuerType);
            Optional.ofNullable(this.getClassificationType()).ifPresent(builder::setClassificationType);
            Optional.ofNullable(this.getOptionExerciseStyle()).ifPresent(builder::setOptionExerciseStyle);
            Optional.ofNullable(this.getUnderlyingAssetType()).ifPresent(builder::setUnderlyingAssetType);
            Optional.ofNullable(this.getSingleorMultiCurrency()).ifPresent(builder::setSingleorMultiCurrency);
            Optional.ofNullable(this.getCFIDeliveryType()).ifPresent(builder::setCFIDeliveryType);
            Optional.ofNullable(this.getUnderlyingRecord()).ifPresent(builder::setUnderlyingRecord);
            Optional.ofNullable(this.getCFIOptionStyleandType()).ifPresent(builder::setCFIOptionStyleandType);
            Optional.ofNullable(this.getUnderlierName()).ifPresent(builder::setUnderlierName);
            Optional.ofNullable(this.getUnderlyingAssetClass()).ifPresent(builder::setUnderlyingAssetClass);
            Optional.ofNullable(this.getDeliveryType()).ifPresent(builder::setDeliveryType);
            Optional.ofNullable(this.getFurtherGrouping()).ifPresent(builder::setFurtherGrouping);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AnnaDsbDerived _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.returnorPayoutTrigger, (Object)_that.getReturnorPayoutTrigger())) {
                return false;
            }
            if (!Objects.equals(this.underlierCharacteristic, _that.getUnderlierCharacteristic())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethodorTrigger, (Object)_that.getValuationMethodorTrigger())) {
                return false;
            }
            if (!Objects.equals(this.shortName, _that.getShortName())) {
                return false;
            }
            if (!Objects.equals((Object)this.underlyingIssuerType, (Object)_that.getUnderlyingIssuerType())) {
                return false;
            }
            if (!Objects.equals(this.classificationType, _that.getClassificationType())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionExerciseStyle, (Object)_that.getOptionExerciseStyle())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetType, _that.getUnderlyingAssetType())) {
                return false;
            }
            if (!Objects.equals((Object)this.singleorMultiCurrency, (Object)_that.getSingleorMultiCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.cFIDeliveryType, (Object)_that.getCFIDeliveryType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyingRecord, _that.getUnderlyingRecord())) {
                return false;
            }
            if (!Objects.equals((Object)this.cFIOptionStyleandType, (Object)_that.getCFIOptionStyleandType())) {
                return false;
            }
            if (!Objects.equals(this.underlierName, _that.getUnderlierName())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetClass, _that.getUnderlyingAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType())) {
                return false;
            }
            return Objects.equals(this.furtherGrouping, _that.getFurtherGrouping());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.returnorPayoutTrigger != null ? ((Object)((Object)this.returnorPayoutTrigger)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlierCharacteristic != null ? this.underlierCharacteristic.hashCode() : 0);
            _result = 31 * _result + (this.valuationMethodorTrigger != null ? ((Object)((Object)this.valuationMethodorTrigger)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.shortName != null ? this.shortName.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIssuerType != null ? ((Object)((Object)this.underlyingIssuerType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.classificationType != null ? this.classificationType.hashCode() : 0);
            _result = 31 * _result + (this.optionExerciseStyle != null ? ((Object)((Object)this.optionExerciseStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetType != null ? this.underlyingAssetType.hashCode() : 0);
            _result = 31 * _result + (this.singleorMultiCurrency != null ? ((Object)((Object)this.singleorMultiCurrency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cFIDeliveryType != null ? ((Object)((Object)this.cFIDeliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingRecord != null ? this.underlyingRecord.hashCode() : 0);
            _result = 31 * _result + (this.cFIOptionStyleandType != null ? ((Object)((Object)this.cFIOptionStyleandType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlierName != null ? this.underlierName.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetClass != null ? this.underlyingAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.furtherGrouping != null ? this.furtherGrouping.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AnnaDsbDerived {ReturnorPayoutTrigger=" + String.valueOf((Object)this.returnorPayoutTrigger) + ", UnderlierCharacteristic=" + this.underlierCharacteristic + ", ValuationMethodorTrigger=" + String.valueOf((Object)this.valuationMethodorTrigger) + ", ShortName=" + this.shortName + ", UnderlyingIssuerType=" + String.valueOf((Object)this.underlyingIssuerType) + ", ClassificationType=" + this.classificationType + ", OptionExerciseStyle=" + String.valueOf((Object)this.optionExerciseStyle) + ", UnderlyingAssetType=" + this.underlyingAssetType + ", SingleorMultiCurrency=" + String.valueOf((Object)this.singleorMultiCurrency) + ", CFIDeliveryType=" + String.valueOf((Object)this.cFIDeliveryType) + ", UnderlyingRecord=" + String.valueOf(this.underlyingRecord) + ", CFIOptionStyleandType=" + String.valueOf((Object)this.cFIOptionStyleandType) + ", UnderlierName=" + this.underlierName + ", UnderlyingAssetClass=" + String.valueOf(this.underlyingAssetClass) + ", DeliveryType=" + String.valueOf((Object)this.deliveryType) + ", FurtherGrouping=" + this.furtherGrouping + "}";
        }
    }
}

