/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.standards.iso.MicData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MicDataCardinalityVerification")
@ImplementedBy(value=Default.class)
public interface MicDataCardinalityVerification
extends Validator<MicData> {
    public static final String NAME = "MicDataCardinalityVerification";
    public static final String DEFINITION = "if micValidation is absent or micValidation = True then micType exists";

    public static class NoOp
    implements MicDataCardinalityVerification {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MicData micData) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MicDataCardinalityVerification {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MicData micData) {
            ComparisonResult result = this.executeDataRule(micData);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MicDataCardinalityVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MicData", (RosettaPath)path, (String)MicDataCardinalityVerification.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MicDataCardinalityVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MicData", (RosettaPath)path, (String)MicDataCardinalityVerification.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MicData micData) {
            try {
                if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)micData).map("getMicValidation", _micData -> _micData.getMicValidation())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)micData).map("getMicValidation", _micData -> _micData.getMicValidation()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)micData).map("getMicType", _micData -> _micData.getMicType()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

