/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.standards.iso.MicData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MicDataMICIsNotXOFFOrXXXX")
@ImplementedBy(value=Default.class)
public interface MicDataMICIsNotXOFFOrXXXX
extends Validator<MicData> {
    public static final String NAME = "MicDataMICIsNotXOFFOrXXXX";
    public static final String DEFINITION = "if mic exists and mic <> \"XXXX\" and mic <> \"XOFF\" then nameInstitutionDescription exists and countryCode exists and city exists and status exists and creationDate exists";

    public static class NoOp
    implements MicDataMICIsNotXOFFOrXXXX {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MicData micData) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MicDataMICIsNotXOFFOrXXXX {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MicData micData) {
            ComparisonResult result = this.executeDataRule(micData);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MicDataMICIsNotXOFFOrXXXX.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MicData", (RosettaPath)path, (String)MicDataMICIsNotXOFFOrXXXX.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MicDataMICIsNotXOFFOrXXXX.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MicData", (RosettaPath)path, (String)MicDataMICIsNotXOFFOrXXXX.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MicData micData) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)micData).map("getMic", _micData -> _micData.getMic())).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)micData).map("getMic", _micData -> _micData.getMic()), (Mapper)MapperS.of((Object)"XXXX"), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)micData).map("getMic", _micData -> _micData.getMic()), (Mapper)MapperS.of((Object)"XOFF"), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)micData).map("getNameInstitutionDescription", _micData -> _micData.getNameInstitutionDescription())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)micData).map("getCountryCode", _micData -> _micData.getCountryCode()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)micData).map("getCity", _micData -> _micData.getCity()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)micData).map("getStatus", _micData -> _micData.getStatus()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)micData).map("getCreationDate", _micData -> _micData.getCreationDate())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

