/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.meta;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.meta.RosettaMetaData;
import java.lang.reflect.InvocationTargetException;

public class RosettaMetaDataBuilder {
    public static <T extends RosettaModelObject> RosettaMetaData<T> getMetaData(T t) {
        String metaClassName = RosettaMetaDataBuilder.getMetaClassName(t);
        try {
            return RosettaMetaDataBuilder.castToMeta(Class.forName(metaClassName, true, t.getClass().getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to instantiate RosettaMetaData class: " + metaClassName, e);
        }
    }

    private static <T extends RosettaModelObject> String getMetaClassName(T t) {
        Class<? extends RosettaModelObject> class1 = t.getType();
        String simpleName = class1.getSimpleName();
        String name = class1.getName();
        String packageName = name.substring(0, name.lastIndexOf(simpleName));
        return packageName + "meta." + simpleName + "Meta";
    }

    private static <T extends RosettaModelObject> RosettaMetaData<T> castToMeta(Object object) {
        return (RosettaMetaData)object;
    }
}

