/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.qualify;

import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class QualifyResult
implements Comparable<QualifyResult> {
    private final String name;
    private final String definition;
    private final Collection<ExpressionDataRuleResult> expressionDataRuleResults;
    private final boolean success;

    public QualifyResult(QualifyResultBuilder builder) {
        this.name = builder.name;
        this.definition = builder.definition;
        boolean andDataRulesSuccess = builder.andDataRuleResults.stream().allMatch(r -> r.isSuccess());
        boolean orDataRulesSuccess = builder.orDataRuleResults.stream().anyMatch(r -> r.isSuccess());
        this.success = builder.expressionResult.isSuccess() && (andDataRulesSuccess || orDataRulesSuccess);
        this.expressionDataRuleResults = new ArrayList<ExpressionDataRuleResult>();
        this.expressionDataRuleResults.add(builder.expressionResult);
        this.expressionDataRuleResults.addAll(builder.andDataRuleResults);
        this.expressionDataRuleResults.addAll(builder.orDataRuleResults);
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public Collection<ExpressionDataRuleResult> getExpressionDataRuleResults() {
        return this.expressionDataRuleResults;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public int compareTo(QualifyResult o) {
        return Boolean.compare(o.success, this.success);
    }

    public String toString() {
        return String.format("QualifyResult.%s %s %s", this.name, this.success ? "SUCCESS" : "FAILURE", this.expressionDataRuleResults);
    }

    public static QualifyResultBuilder builder() {
        return new QualifyResultBuilder();
    }

    public static class QualifyResultBuilder {
        private String name;
        private String definition;
        private ExpressionDataRuleResult expressionResult;
        private final Collection<ExpressionDataRuleResult> andDataRuleResults = new ArrayList<ExpressionDataRuleResult>();
        private final Collection<ExpressionDataRuleResult> orDataRuleResults = new ArrayList<ExpressionDataRuleResult>();

        public QualifyResultBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public QualifyResultBuilder setDefinition(String definition) {
            this.definition = definition;
            return this;
        }

        public QualifyResultBuilder setExpressionResult(String definition, ComparisonResult result) {
            this.expressionResult = ExpressionDataRuleResult.fromExpression(definition, result);
            return this;
        }

        public QualifyResultBuilder addAndDataRuleResult(ValidationResult<?> result) {
            this.andDataRuleResults.add(ExpressionDataRuleResult.fromDataRule(result, "and"));
            return this;
        }

        public QualifyResultBuilder addOrDataRuleResult(ValidationResult<?> result) {
            this.orDataRuleResults.add(ExpressionDataRuleResult.fromDataRule(result, "or"));
            return this;
        }

        public QualifyResult build() {
            return new QualifyResult(this);
        }
    }

    public static class ExpressionDataRuleResult {
        private final String name;
        private final Type type;
        private final String definition;
        private final Optional<String> operator;
        private final boolean success;
        private final String error;

        static ExpressionDataRuleResult fromExpression(String definition, ComparisonResult result) {
            return new ExpressionDataRuleResult("Expression", Type.Expression, definition, Optional.empty(), result.get(), result.getError());
        }

        static ExpressionDataRuleResult fromDataRule(ValidationResult<?> result, String operator) {
            return new ExpressionDataRuleResult(result.getName(), Type.DataRule, result.getDefinition(), Optional.ofNullable(operator), result.isSuccess(), result.getFailureReason().orElse(""));
        }

        private ExpressionDataRuleResult(String name, Type type, String definition, Optional<String> operator, boolean success, String error) {
            this.name = name;
            this.type = type;
            this.definition = definition;
            this.operator = operator;
            this.success = success;
            this.error = error;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public String getDefinition() {
            return this.definition;
        }

        public String getOperator() {
            return this.operator.orElse("");
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getError() {
            return this.error;
        }

        public String toString() {
            switch (this.type.ordinal()) {
                case 0: {
                    return String.format("Result.Expression %s %s", this.success ? "SUCCESS" : "FAILURE", this.success ? "" : "Error: {" + this.error + "}").trim();
                }
                case 1: {
                    return String.format("Result.DataRule.%s %s %s", this.name, this.success ? "SUCCESS" : "FAILURE", this.success ? "" : "Error: {" + this.error + "}").trim();
                }
            }
            return "ExpressionDataRuleResult [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", definition=" + this.definition + ", operator=" + this.operator + ", success=" + this.success + ", error=" + this.error + "]";
        }

        public static enum Type {
            Expression,
            DataRule;

        }
    }
}

