/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.observable.asset.Price;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=EquityNotionalAmountDefault.class)
public abstract class EquityNotionalAmount
implements RosettaFunction {
    public BigDecimal evaluate(BigDecimal numberOfSecurities, Price price) {
        BigDecimal equityNotionalAmount = this.doEvaluate(numberOfSecurities, price);
        return equityNotionalAmount;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, Price var2);

    protected abstract MapperS<BigDecimal> priceValue(BigDecimal var1, Price var2);

    public static class EquityNotionalAmountDefault
    extends EquityNotionalAmount {
        @Override
        protected BigDecimal doEvaluate(BigDecimal numberOfSecurities, Price price) {
            BigDecimal equityNotionalAmount = null;
            return this.assignOutput(equityNotionalAmount, numberOfSecurities, price);
        }

        protected BigDecimal assignOutput(BigDecimal equityNotionalAmount, BigDecimal numberOfSecurities, Price price) {
            equityNotionalAmount = (BigDecimal)MapperMaths.multiply((Mapper)MapperS.of((Object)numberOfSecurities), this.priceValue(numberOfSecurities, price)).get();
            return equityNotionalAmount;
        }

        @Override
        protected MapperS<BigDecimal> priceValue(BigDecimal numberOfSecurities, Price price) {
            return MapperS.of((Object)price).map("getValue", _price -> _price.getValue());
        }
    }
}

