/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.FieldWithMetaFloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.observable.event.ObservationIdentifier;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveInterestRateObservationIdentifiersDefault.class)
public abstract class ResolveInterestRateObservationIdentifiers
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ObservationIdentifier evaluate(InterestRatePayout payout, Date date) {
        ObservationIdentifier identifiers;
        ObservationIdentifier.ObservationIdentifierBuilder identifiersBuilder = this.doEvaluate(payout, date);
        if (identifiersBuilder == null) {
            identifiers = null;
        } else {
            identifiers = identifiersBuilder.build();
            this.objectValidator.validate(ObservationIdentifier.class, (RosettaModelObject)identifiers);
        }
        return identifiers;
    }

    protected abstract ObservationIdentifier.ObservationIdentifierBuilder doEvaluate(InterestRatePayout var1, Date var2);

    public static class ResolveInterestRateObservationIdentifiersDefault
    extends ResolveInterestRateObservationIdentifiers {
        @Override
        protected ObservationIdentifier.ObservationIdentifierBuilder doEvaluate(InterestRatePayout payout, Date date) {
            ObservationIdentifier.ObservationIdentifierBuilder identifiers = ObservationIdentifier.builder();
            return this.assignOutput(identifiers, payout, date);
        }

        protected ObservationIdentifier.ObservationIdentifierBuilder assignOutput(ObservationIdentifier.ObservationIdentifierBuilder identifiers, InterestRatePayout payout, Date date) {
            FloatingRateOption floatingRateOption;
            ReferenceWithMetaFloatingRateOption referenceWithMetaFloatingRateOption = (ReferenceWithMetaFloatingRateOption)MapperS.of((Object)payout).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).get();
            FieldWithMetaFloatingRateOption ifThenElseResult = referenceWithMetaFloatingRateOption == null ? FieldWithMetaFloatingRateOption.builder().build() : ((floatingRateOption = referenceWithMetaFloatingRateOption.getValue()) == null ? FieldWithMetaFloatingRateOption.builder().build() : FieldWithMetaFloatingRateOption.builder().setValue(floatingRateOption).build());
            identifiers.getOrCreateObservable().setRateOption(ifThenElseResult);
            identifiers.setObservationDate(date);
            return Optional.ofNullable(identifiers).map(o -> o.prune()).orElse(null);
        }
    }
}

