/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.ReferencePoolItem;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ReferencePoolItemSettlementChoice")
@ImplementedBy(value=Default.class)
public interface ReferencePoolItemSettlementChoice
extends Validator<ReferencePoolItem> {
    public static final String NAME = "ReferencePoolItemSettlementChoice";
    public static final String DEFINITION = "optional choice cashSettlementTermsReference, physicalSettlementTermsReference";

    public static class NoOp
    implements ReferencePoolItemSettlementChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReferencePoolItem referencePoolItem) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ReferencePoolItemSettlementChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReferencePoolItem referencePoolItem) {
            ComparisonResult result = this.executeDataRule(referencePoolItem);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ReferencePoolItemSettlementChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferencePoolItem", (RosettaPath)path, (String)ReferencePoolItemSettlementChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ReferencePoolItemSettlementChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferencePoolItem", (RosettaPath)path, (String)ReferencePoolItemSettlementChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ReferencePoolItem referencePoolItem) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)referencePoolItem), Arrays.asList("cashSettlementTermsReference", "physicalSettlementTermsReference"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

