/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.product.common.settlement.meta.ComputedAmountMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ComputedAmount", builder=ComputedAmountBuilderImpl.class, version="5.30.0")
@RuneDataType(value="ComputedAmount", model="cdm", builder=ComputedAmountBuilderImpl.class, version="5.30.0")
public interface ComputedAmount
extends RosettaModelObject {
    public static final ComputedAmountMeta metaData = new ComputedAmountMeta();

    public String getCallFunction();

    public BigDecimal getAmount();

    public FieldWithMetaString getCurrency();

    public ComputedAmount build();

    public ComputedAmountBuilder toBuilder();

    public static ComputedAmountBuilder builder() {
        return new ComputedAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends ComputedAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ComputedAmount> getType() {
        return ComputedAmount.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("callFunction"), String.class, (Object)this.getCallFunction(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.class, this.getCurrency(), new AttributeMeta[0]);
    }

    public static class ComputedAmountBuilderImpl
    implements ComputedAmountBuilder {
        protected String callFunction;
        protected BigDecimal amount;
        protected FieldWithMetaString.FieldWithMetaStringBuilder currency;

        @Override
        @RosettaAttribute(value="callFunction", isRequired=true)
        @RuneAttribute(value="callFunction", isRequired=true)
        public String getCallFunction() {
            return this.callFunction;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.currency != null ? this.currency : (this.currency = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="callFunction", isRequired=true)
        @RuneAttribute(value="callFunction", isRequired=true)
        public ComputedAmountBuilder setCallFunction(String _callFunction) {
            this.callFunction = _callFunction == null ? null : _callFunction;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public ComputedAmountBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ComputedAmountBuilder setCurrency(FieldWithMetaString _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        public ComputedAmountBuilder setCurrencyValue(String _currency) {
            this.getOrCreateCurrency().setValue(_currency);
            return this;
        }

        @Override
        public ComputedAmount build() {
            return new ComputedAmountImpl(this);
        }

        @Override
        public ComputedAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public ComputedAmountBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCallFunction() != null) {
                return true;
            }
            if (this.getAmount() != null) {
                return true;
            }
            return this.getCurrency() != null;
        }

        public ComputedAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ComputedAmountBuilder o = (ComputedAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeBasic((Object)this.getCallFunction(), (Object)o.getCallFunction(), this::setCallFunction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ComputedAmount _that = this.getType().cast(o);
            if (!Objects.equals(this.callFunction, _that.getCallFunction())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.callFunction != null ? this.callFunction.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ComputedAmountBuilder {callFunction=" + this.callFunction + ", amount=" + this.amount + ", currency=" + this.currency + '}';
        }
    }

    public static interface ComputedAmountBuilder
    extends ComputedAmount,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency();

        public ComputedAmountBuilder setCallFunction(String var1);

        public ComputedAmountBuilder setAmount(BigDecimal var1);

        public ComputedAmountBuilder setCurrency(FieldWithMetaString var1);

        public ComputedAmountBuilder setCurrencyValue(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("callFunction"), String.class, (Object)this.getCallFunction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getCurrency(), new AttributeMeta[0]);
        }

        public ComputedAmountBuilder prune();
    }

    public static class ComputedAmountImpl
    implements ComputedAmount {
        private final String callFunction;
        private final BigDecimal amount;
        private final FieldWithMetaString currency;

        protected ComputedAmountImpl(ComputedAmountBuilder builder) {
            this.callFunction = builder.getCallFunction();
            this.amount = builder.getAmount();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="callFunction", isRequired=true)
        @RuneAttribute(value="callFunction", isRequired=true)
        public String getCallFunction() {
            return this.callFunction;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public FieldWithMetaString getCurrency() {
            return this.currency;
        }

        @Override
        public ComputedAmount build() {
            return this;
        }

        @Override
        public ComputedAmountBuilder toBuilder() {
            ComputedAmountBuilder builder = ComputedAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ComputedAmountBuilder builder) {
            Optional.ofNullable(this.getCallFunction()).ifPresent(builder::setCallFunction);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ComputedAmount _that = this.getType().cast(o);
            if (!Objects.equals(this.callFunction, _that.getCallFunction())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.callFunction != null ? this.callFunction.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ComputedAmount {callFunction=" + this.callFunction + ", amount=" + this.amount + ", currency=" + this.currency + '}';
        }
    }
}

