/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.RelativeDateOffset;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.Money;
import cdm.observable.asset.metafields.ReferenceWithMetaMoney;
import cdm.product.template.meta.ExerciseFeeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ExerciseFee", builder=ExerciseFeeBuilderImpl.class, version="5.30.0")
@RuneDataType(value="ExerciseFee", model="cdm", builder=ExerciseFeeBuilderImpl.class, version="5.30.0")
public interface ExerciseFee
extends PayerReceiver {
    public static final ExerciseFeeMeta metaData = new ExerciseFeeMeta();

    public ReferenceWithMetaMoney getNotionalReference();

    public BigDecimal getFeeAmount();

    public BigDecimal getFeeRate();

    public RelativeDateOffset getFeePaymentDate();

    @Override
    public ExerciseFee build();

    @Override
    public ExerciseFeeBuilder toBuilder();

    public static ExerciseFeeBuilder builder() {
        return new ExerciseFeeBuilderImpl();
    }

    default public RosettaMetaData<? extends ExerciseFee> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExerciseFee> getType() {
        return ExerciseFee.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("payer"), CounterpartyRoleEnum.class, (Object)this.getPayer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("receiver"), CounterpartyRoleEnum.class, (Object)this.getReceiver(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalReference"), processor, ReferenceWithMetaMoney.class, this.getNotionalReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("feeAmount"), BigDecimal.class, (Object)this.getFeeAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("feeRate"), BigDecimal.class, (Object)this.getFeeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feePaymentDate"), processor, RelativeDateOffset.class, this.getFeePaymentDate(), new AttributeMeta[0]);
    }

    public static class ExerciseFeeBuilderImpl
    extends PayerReceiver.PayerReceiverBuilderImpl
    implements ExerciseFeeBuilder {
        protected ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder notionalReference;
        protected BigDecimal feeAmount;
        protected BigDecimal feeRate;
        protected RelativeDateOffset.RelativeDateOffsetBuilder feePaymentDate;

        @Override
        @RosettaAttribute(value="notionalReference", isRequired=true)
        @RuneAttribute(value="notionalReference", isRequired=true)
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getNotionalReference() {
            return this.notionalReference;
        }

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getOrCreateNotionalReference() {
            ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder result = this.notionalReference != null ? this.notionalReference : (this.notionalReference = ReferenceWithMetaMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="feeAmount")
        @RuneAttribute(value="feeAmount")
        public BigDecimal getFeeAmount() {
            return this.feeAmount;
        }

        @Override
        @RosettaAttribute(value="feeRate")
        @RuneAttribute(value="feeRate")
        public BigDecimal getFeeRate() {
            return this.feeRate;
        }

        @Override
        @RosettaAttribute(value="feePaymentDate", isRequired=true)
        @RuneAttribute(value="feePaymentDate", isRequired=true)
        public RelativeDateOffset.RelativeDateOffsetBuilder getFeePaymentDate() {
            return this.feePaymentDate;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateFeePaymentDate() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.feePaymentDate != null ? this.feePaymentDate : (this.feePaymentDate = RelativeDateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payer", isRequired=true)
        @RuneAttribute(value="payer", isRequired=true)
        public ExerciseFeeBuilder setPayer(CounterpartyRoleEnum _payer) {
            this.payer = _payer == null ? null : _payer;
            return this;
        }

        @Override
        @RosettaAttribute(value="receiver", isRequired=true)
        @RuneAttribute(value="receiver", isRequired=true)
        public ExerciseFeeBuilder setReceiver(CounterpartyRoleEnum _receiver) {
            this.receiver = _receiver == null ? null : _receiver;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalReference", isRequired=true)
        @RuneAttribute(value="notionalReference", isRequired=true)
        public ExerciseFeeBuilder setNotionalReference(ReferenceWithMetaMoney _notionalReference) {
            this.notionalReference = _notionalReference == null ? null : _notionalReference.toBuilder();
            return this;
        }

        @Override
        public ExerciseFeeBuilder setNotionalReferenceValue(Money _notionalReference) {
            this.getOrCreateNotionalReference().setValue(_notionalReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="feeAmount")
        @RuneAttribute(value="feeAmount")
        public ExerciseFeeBuilder setFeeAmount(BigDecimal _feeAmount) {
            this.feeAmount = _feeAmount == null ? null : _feeAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="feeRate")
        @RuneAttribute(value="feeRate")
        public ExerciseFeeBuilder setFeeRate(BigDecimal _feeRate) {
            this.feeRate = _feeRate == null ? null : _feeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="feePaymentDate", isRequired=true)
        @RuneAttribute(value="feePaymentDate", isRequired=true)
        public ExerciseFeeBuilder setFeePaymentDate(RelativeDateOffset _feePaymentDate) {
            this.feePaymentDate = _feePaymentDate == null ? null : _feePaymentDate.toBuilder();
            return this;
        }

        @Override
        public ExerciseFee build() {
            return new ExerciseFeeImpl(this);
        }

        @Override
        public ExerciseFeeBuilder toBuilder() {
            return this;
        }

        @Override
        public ExerciseFeeBuilder prune() {
            super.prune();
            if (this.notionalReference != null && !this.notionalReference.prune().hasData()) {
                this.notionalReference = null;
            }
            if (this.feePaymentDate != null && !this.feePaymentDate.prune().hasData()) {
                this.feePaymentDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNotionalReference() != null && this.getNotionalReference().hasData()) {
                return true;
            }
            if (this.getFeeAmount() != null) {
                return true;
            }
            if (this.getFeeRate() != null) {
                return true;
            }
            return this.getFeePaymentDate() != null && this.getFeePaymentDate().hasData();
        }

        @Override
        public ExerciseFeeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExerciseFeeBuilder o = (ExerciseFeeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalReference(), (RosettaModelObjectBuilder)o.getNotionalReference(), this::setNotionalReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeePaymentDate(), (RosettaModelObjectBuilder)o.getFeePaymentDate(), this::setFeePaymentDate);
            merger.mergeBasic((Object)this.getFeeAmount(), (Object)o.getFeeAmount(), this::setFeeAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFeeRate(), (Object)o.getFeeRate(), this::setFeeRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExerciseFee _that = (ExerciseFee)this.getType().cast(o);
            if (!Objects.equals(this.notionalReference, _that.getNotionalReference())) {
                return false;
            }
            if (!Objects.equals(this.feeAmount, _that.getFeeAmount())) {
                return false;
            }
            if (!Objects.equals(this.feeRate, _that.getFeeRate())) {
                return false;
            }
            return Objects.equals(this.feePaymentDate, _that.getFeePaymentDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notionalReference != null ? this.notionalReference.hashCode() : 0);
            _result = 31 * _result + (this.feeAmount != null ? this.feeAmount.hashCode() : 0);
            _result = 31 * _result + (this.feeRate != null ? this.feeRate.hashCode() : 0);
            _result = 31 * _result + (this.feePaymentDate != null ? this.feePaymentDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExerciseFeeBuilder {notionalReference=" + this.notionalReference + ", feeAmount=" + this.feeAmount + ", feeRate=" + this.feeRate + ", feePaymentDate=" + this.feePaymentDate + '}' + " " + super.toString();
        }
    }

    public static interface ExerciseFeeBuilder
    extends ExerciseFee,
    PayerReceiver.PayerReceiverBuilder {
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getOrCreateNotionalReference();

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getNotionalReference();

        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateFeePaymentDate();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getFeePaymentDate();

        @Override
        public ExerciseFeeBuilder setPayer(CounterpartyRoleEnum var1);

        @Override
        public ExerciseFeeBuilder setReceiver(CounterpartyRoleEnum var1);

        public ExerciseFeeBuilder setNotionalReference(ReferenceWithMetaMoney var1);

        public ExerciseFeeBuilder setNotionalReferenceValue(Money var1);

        public ExerciseFeeBuilder setFeeAmount(BigDecimal var1);

        public ExerciseFeeBuilder setFeeRate(BigDecimal var1);

        public ExerciseFeeBuilder setFeePaymentDate(RelativeDateOffset var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("payer"), CounterpartyRoleEnum.class, (Object)this.getPayer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("receiver"), CounterpartyRoleEnum.class, (Object)this.getReceiver(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalReference"), processor, ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder.class, this.getNotionalReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("feeAmount"), BigDecimal.class, (Object)this.getFeeAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("feeRate"), BigDecimal.class, (Object)this.getFeeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feePaymentDate"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getFeePaymentDate(), new AttributeMeta[0]);
        }

        @Override
        public ExerciseFeeBuilder prune();
    }

    public static class ExerciseFeeImpl
    extends PayerReceiver.PayerReceiverImpl
    implements ExerciseFee {
        private final ReferenceWithMetaMoney notionalReference;
        private final BigDecimal feeAmount;
        private final BigDecimal feeRate;
        private final RelativeDateOffset feePaymentDate;

        protected ExerciseFeeImpl(ExerciseFeeBuilder builder) {
            super(builder);
            this.notionalReference = Optional.ofNullable(builder.getNotionalReference()).map(f -> f.build()).orElse(null);
            this.feeAmount = builder.getFeeAmount();
            this.feeRate = builder.getFeeRate();
            this.feePaymentDate = Optional.ofNullable(builder.getFeePaymentDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="notionalReference", isRequired=true)
        @RuneAttribute(value="notionalReference", isRequired=true)
        public ReferenceWithMetaMoney getNotionalReference() {
            return this.notionalReference;
        }

        @Override
        @RosettaAttribute(value="feeAmount")
        @RuneAttribute(value="feeAmount")
        public BigDecimal getFeeAmount() {
            return this.feeAmount;
        }

        @Override
        @RosettaAttribute(value="feeRate")
        @RuneAttribute(value="feeRate")
        public BigDecimal getFeeRate() {
            return this.feeRate;
        }

        @Override
        @RosettaAttribute(value="feePaymentDate", isRequired=true)
        @RuneAttribute(value="feePaymentDate", isRequired=true)
        public RelativeDateOffset getFeePaymentDate() {
            return this.feePaymentDate;
        }

        @Override
        public ExerciseFee build() {
            return this;
        }

        @Override
        public ExerciseFeeBuilder toBuilder() {
            ExerciseFeeBuilder builder = ExerciseFee.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExerciseFeeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNotionalReference()).ifPresent(builder::setNotionalReference);
            Optional.ofNullable(this.getFeeAmount()).ifPresent(builder::setFeeAmount);
            Optional.ofNullable(this.getFeeRate()).ifPresent(builder::setFeeRate);
            Optional.ofNullable(this.getFeePaymentDate()).ifPresent(builder::setFeePaymentDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExerciseFee _that = (ExerciseFee)this.getType().cast(o);
            if (!Objects.equals(this.notionalReference, _that.getNotionalReference())) {
                return false;
            }
            if (!Objects.equals(this.feeAmount, _that.getFeeAmount())) {
                return false;
            }
            if (!Objects.equals(this.feeRate, _that.getFeeRate())) {
                return false;
            }
            return Objects.equals(this.feePaymentDate, _that.getFeePaymentDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notionalReference != null ? this.notionalReference.hashCode() : 0);
            _result = 31 * _result + (this.feeAmount != null ? this.feeAmount.hashCode() : 0);
            _result = 31 * _result + (this.feeRate != null ? this.feeRate.hashCode() : 0);
            _result = 31 * _result + (this.feePaymentDate != null ? this.feePaymentDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExerciseFee {notionalReference=" + this.notionalReference + ", feeAmount=" + this.feeAmount + ", feeRate=" + this.feeRate + ", feePaymentDate=" + this.feePaymentDate + '}' + " " + super.toString();
        }
    }
}

