/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.Guavate;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class MapStream<K, V>
implements Stream<Map.Entry<K, V>> {
    private final Stream<Map.Entry<K, V>> underlying;

    public static <K, V> MapStream<K, V> of(Map<K, V> map) {
        return new MapStream<K, V>(map.entrySet().stream());
    }

    public static <K, V> MapStream<K, V> of(Collection<V> collection, Function<V, K> keyFunction) {
        return MapStream.of(collection.stream(), keyFunction);
    }

    public static <T, K, V> MapStream<K, V> of(Collection<T> collection, Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return MapStream.of(collection.stream(), keyFunction, valueFunction);
    }

    public static <K, V> MapStream<K, V> of(Stream<V> stream, Function<V, K> keyFunction) {
        return new MapStream<K, V>(stream.map((? super T v) -> MapStream.entry(keyFunction.apply(v), v)));
    }

    public static <T, K, V> MapStream<K, V> of(Stream<T> stream, Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return new MapStream<K, V>(stream.map((? super T item) -> MapStream.entry(keyFunction.apply(item), valueFunction.apply(item))));
    }

    public static <K, V> MapStream<K, V> empty() {
        return new MapStream<K, V>(Stream.empty());
    }

    private MapStream(Stream<Map.Entry<K, V>> underlying) {
        this.underlying = underlying;
    }

    public MapStream<K, V> filter(BiFunction<? super K, ? super V, Boolean> predicate) {
        return MapStream.wrap(this.underlying.filter((? super T e) -> (Boolean)predicate.apply((Object)e.getKey(), (Object)e.getValue())));
    }

    public MapStream<K, V> filterKeys(Predicate<? super K> predicate) {
        return MapStream.wrap(this.underlying.filter((? super T e) -> predicate.test((Object)e.getKey())));
    }

    public MapStream<K, V> filterValues(Predicate<? super V> predicate) {
        return MapStream.wrap(this.underlying.filter((? super T e) -> predicate.test((Object)e.getValue())));
    }

    public <R> MapStream<R, V> mapKeys(Function<? super K, ? extends R> mapper) {
        return MapStream.wrap(this.underlying.map((? super T e) -> MapStream.entry(mapper.apply((Object)e.getKey()), e.getValue())));
    }

    public <R> MapStream<R, V> mapKeys(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return MapStream.wrap(this.underlying.map((? super T e) -> MapStream.entry(mapper.apply((Object)e.getKey(), (Object)e.getValue()), e.getValue())));
    }

    public <R> MapStream<K, R> mapValues(Function<? super V, ? extends R> mapper) {
        return MapStream.wrap(this.underlying.map((? super T e) -> MapStream.entry(e.getKey(), mapper.apply((Object)e.getValue()))));
    }

    public <R> MapStream<K, R> mapValues(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return MapStream.wrap(this.underlying.map((? super T e) -> MapStream.entry(e.getKey(), mapper.apply((Object)e.getKey(), (Object)e.getValue()))));
    }

    public <R> Stream<R> map(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return this.underlying.map((? super T e) -> mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    public ImmutableMap<K, V> toMap() {
        return this.underlying.collect(Guavate.toImmutableMap(e -> e.getKey(), e -> e.getValue()));
    }

    public ImmutableMap<K, V> toMap(BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        return this.underlying.collect(Guavate.toImmutableMap(e -> e.getKey(), e -> e.getValue(), mergeFn));
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.underlying.forEach((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    public MapStream<K, V> filter(Predicate<? super Map.Entry<K, V>> predicate) {
        return MapStream.wrap(this.underlying.filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super Map.Entry<K, V>, ? extends R> mapper) {
        return this.underlying.map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super Map.Entry<K, V>> mapper) {
        return this.underlying.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super Map.Entry<K, V>> mapper) {
        return this.underlying.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super Map.Entry<K, V>> mapper) {
        return this.underlying.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super Map.Entry<K, V>, ? extends Stream<? extends R>> mapper) {
        return this.underlying.flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super Map.Entry<K, V>, ? extends IntStream> mapper) {
        return this.underlying.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super Map.Entry<K, V>, ? extends LongStream> mapper) {
        return this.underlying.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super Map.Entry<K, V>, ? extends DoubleStream> mapper) {
        return this.underlying.flatMapToDouble(mapper);
    }

    public MapStream<K, V> distinct() {
        return MapStream.wrap(this.underlying.distinct());
    }

    public MapStream<K, V> sorted() {
        return MapStream.wrap(this.underlying.sorted());
    }

    public MapStream<K, V> sorted(Comparator<? super Map.Entry<K, V>> comparator) {
        return MapStream.wrap(this.underlying.sorted(comparator));
    }

    public MapStream<K, V> peek(Consumer<? super Map.Entry<K, V>> action) {
        return MapStream.wrap(this.underlying.peek(action));
    }

    public MapStream<K, V> limit(long maxSize) {
        return MapStream.wrap(this.underlying.limit(maxSize));
    }

    public MapStream<K, V> skip(long n) {
        return MapStream.wrap(this.underlying.skip(n));
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        this.underlying.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super Map.Entry<K, V>> action) {
        this.underlying.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.underlying.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.underlying.toArray(generator);
    }

    @Override
    public Map.Entry<K, V> reduce(Map.Entry<K, V> identity, BinaryOperator<Map.Entry<K, V>> accumulator) {
        return this.underlying.reduce(identity, accumulator);
    }

    @Override
    public Optional<Map.Entry<K, V>> reduce(BinaryOperator<Map.Entry<K, V>> accumulator) {
        return this.underlying.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super Map.Entry<K, V>, U> accumulator, BinaryOperator<U> combiner) {
        return this.underlying.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super Map.Entry<K, V>> accumulator, BiConsumer<R, R> combiner) {
        return this.underlying.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super Map.Entry<K, V>, A, R> collector) {
        return this.underlying.collect(collector);
    }

    @Override
    public Optional<Map.Entry<K, V>> min(Comparator<? super Map.Entry<K, V>> comparator) {
        return this.underlying.min(comparator);
    }

    @Override
    public Optional<Map.Entry<K, V>> max(Comparator<? super Map.Entry<K, V>> comparator) {
        return this.underlying.max(comparator);
    }

    @Override
    public long count() {
        return this.underlying.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.underlying.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.underlying.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.underlying.noneMatch(predicate);
    }

    @Override
    public Optional<Map.Entry<K, V>> findFirst() {
        return this.underlying.findFirst();
    }

    @Override
    public Optional<Map.Entry<K, V>> findAny() {
        return this.underlying.findAny();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.underlying.iterator();
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return this.underlying.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.underlying.isParallel();
    }

    @Override
    public MapStream<K, V> sequential() {
        return MapStream.wrap((Stream)this.underlying.sequential());
    }

    @Override
    public MapStream<K, V> parallel() {
        return MapStream.wrap((Stream)this.underlying.parallel());
    }

    @Override
    public MapStream<K, V> unordered() {
        return MapStream.wrap((Stream)this.underlying.unordered());
    }

    @Override
    public MapStream<K, V> onClose(Runnable closeHandler) {
        return MapStream.wrap((Stream)this.underlying.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    private static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    private static <K, V> MapStream<K, V> wrap(Stream<Map.Entry<K, V>> underlying) {
        return new MapStream<K, V>(underlying);
    }
}

