/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.function;

import java.util.Objects;

@FunctionalInterface
public interface ObjDoublePredicate<T> {
    public boolean test(T var1, double var2);

    default public ObjDoublePredicate<T> and(ObjDoublePredicate<? super T> other) {
        Objects.requireNonNull(other);
        return (obj, value) -> this.test(obj, value) && other.test(obj, value);
    }

    default public ObjDoublePredicate<T> or(ObjDoublePredicate<? super T> other) {
        Objects.requireNonNull(other);
        return (obj, value) -> this.test(obj, value) || other.test(obj, value);
    }

    default public ObjDoublePredicate<T> negate() {
        return (obj, value) -> !this.test(obj, value);
    }
}

