/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

public final class XmlElement
implements ImmutableBean {
    private static MetaBean META_BEAN = LightMetaBean.of(XmlElement.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"name", "attributes", "content", "children"}, (Object[])new Object[]{null, ImmutableMap.of(), null, ImmutableList.of()});
    @PropertyDefinition(validate="notNull")
    private final String name;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<String, String> attributes;
    @PropertyDefinition(validate="notNull")
    private final String content;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<XmlElement> children;

    public static XmlElement ofContent(String name, String content) {
        return XmlElement.ofContent(name, (Map<String, String>)ImmutableMap.of(), content);
    }

    public static XmlElement ofContent(String name, Map<String, String> attributes, String content) {
        return new XmlElement(name, (ImmutableMap<String, String>)ImmutableMap.copyOf(attributes), content, (ImmutableList<XmlElement>)ImmutableList.of());
    }

    public static XmlElement ofChildren(String name, List<XmlElement> children) {
        return XmlElement.ofChildren(name, (Map<String, String>)ImmutableMap.of(), children);
    }

    public static XmlElement ofChildren(String name, Map<String, String> attributes, List<XmlElement> children) {
        return new XmlElement(name, (ImmutableMap<String, String>)ImmutableMap.copyOf(attributes), "", (ImmutableList<XmlElement>)ImmutableList.copyOf(children));
    }

    private XmlElement(String name, ImmutableMap<String, String> attributes, String content, ImmutableList<XmlElement> children) {
        this.name = ArgChecker.notEmpty(name, "name");
        this.attributes = ArgChecker.notNull(attributes, "attributes");
        this.content = ArgChecker.notNull(content, "content");
        this.children = ArgChecker.notNull(children, "children");
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute(String attrName) {
        String attrValue = (String)this.attributes.get((Object)attrName);
        if (attrValue == null) {
            throw new IllegalArgumentException(Messages.format("Unknown attribute '{}' on element '{}'", attrName, this.name));
        }
        return attrValue;
    }

    public Optional<String> findAttribute(String attrName) {
        return Optional.ofNullable(this.attributes.get((Object)attrName));
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean hasContent() {
        return this.content.length() > 0;
    }

    public String getContent() {
        return this.content;
    }

    public XmlElement getChild(int index) {
        return (XmlElement)this.children.get(index);
    }

    public ImmutableList<XmlElement> getChildren() {
        return this.children;
    }

    public XmlElement getChild(String childName) {
        return this.findChild(childName).orElseThrow(() -> new IllegalArgumentException(Messages.format("Unknown element '{}' in element '{}'", childName, this.name)));
    }

    public Optional<XmlElement> findChild(String childName) {
        return this.streamChildren(childName).reduce(Guavate.ensureOnlyOne());
    }

    public ImmutableList<XmlElement> getChildren(String childName) {
        return this.streamChildren(childName).collect(Guavate.toImmutableList());
    }

    public Stream<XmlElement> streamChildren(String childName) {
        return this.children.stream().filter(child -> child.getName().equals(childName));
    }

    public MetaBean metaBean() {
        return META_BEAN;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XmlElement) {
            XmlElement other = (XmlElement)obj;
            return this.name.equals(other.name) && Objects.equals(this.content, other.content) && this.attributes.equals(other.attributes) && this.children.equals(other.children);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.content.hashCode();
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + this.children.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(512);
        buf.append('<').append(this.name);
        for (Map.Entry entry : this.attributes.entrySet()) {
            buf.append(' ').append((String)entry.getKey()).append('=').append('\"').append((String)entry.getValue()).append('\"');
        }
        buf.append('>');
        if (this.children.isEmpty()) {
            buf.append(this.content);
        } else {
            for (XmlElement child : this.children) {
                buf.append(System.lineSeparator()).append(" <").append(child.getName()).append(" ... />");
            }
            buf.append(System.lineSeparator());
        }
        buf.append("</").append(this.name).append('>');
        return buf.toString();
    }
}

