/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.processor.collector;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import java.util.HashSet;
import java.util.Set;
import org.finos.rune.mapper.processor.GlobalReferenceRecord;
import org.finos.rune.mapper.processor.collector.CollectorStrategy;

public class GlobalReferenceCollectorStrategy
implements CollectorStrategy {
    private final Set<GlobalReferenceRecord> globalReferences = new HashSet<GlobalReferenceRecord>();

    @Override
    public void collect(RosettaModelObject instance) {
        ReferenceWithMeta reference;
        if (instance instanceof ReferenceWithMeta && (reference = (ReferenceWithMeta)instance).getGlobalReference() != null) {
            Class referenceValueType = reference.getValueType();
            String referenceKeyValue = reference.getGlobalReference();
            this.globalReferences.add(new GlobalReferenceRecord(referenceValueType, referenceKeyValue));
        }
    }

    public Set<GlobalReferenceRecord> getGlobalReferences() {
        return this.globalReferences;
    }
}

