package iso20022.auth030.asic.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.QuantityOrTerm1Choice__1;
import iso20022.auth030.asic.QuantityTerm1__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class QuantityOrTerm1Choice__1Validator implements Validator<QuantityOrTerm1Choice__1> {

	private List<ComparisonResult> getComparisonResults(QuantityOrTerm1Choice__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("term", (QuantityTerm1__1) o.getTerm() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<QuantityOrTerm1Choice__1> validate(RosettaPath path, QuantityOrTerm1Choice__1 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("QuantityOrTerm1Choice__1", ValidationType.CARDINALITY, "QuantityOrTerm1Choice__1", path, "", error);
		}
		return success("QuantityOrTerm1Choice__1", ValidationType.CARDINALITY, "QuantityOrTerm1Choice__1", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, QuantityOrTerm1Choice__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("QuantityOrTerm1Choice__1", ValidationType.CARDINALITY, "QuantityOrTerm1Choice__1", path, "", res.getError());
				}
				return success("QuantityOrTerm1Choice__1", ValidationType.CARDINALITY, "QuantityOrTerm1Choice__1", path, "");
			})
			.collect(toList());
	}

}
