package iso20022.auth030.esma.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.DerivativePartyIdentification1Choice;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class DerivativePartyIdentification1ChoiceValidator implements Validator<DerivativePartyIdentification1Choice> {

	private List<ComparisonResult> getComparisonResults(DerivativePartyIdentification1Choice o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("ctry", (String) o.getCtry() != null ? 1 : 0, 0, 1), 
				checkCardinality("ctrySubDvsn", (String) o.getCtrySubDvsn() != null ? 1 : 0, 0, 1), 
				checkCardinality("lei", (String) o.getLei() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<DerivativePartyIdentification1Choice> validate(RosettaPath path, DerivativePartyIdentification1Choice o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("DerivativePartyIdentification1Choice", ValidationType.CARDINALITY, "DerivativePartyIdentification1Choice", path, "", error);
		}
		return success("DerivativePartyIdentification1Choice", ValidationType.CARDINALITY, "DerivativePartyIdentification1Choice", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, DerivativePartyIdentification1Choice o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("DerivativePartyIdentification1Choice", ValidationType.CARDINALITY, "DerivativePartyIdentification1Choice", path, "", res.getError());
				}
				return success("DerivativePartyIdentification1Choice", ValidationType.CARDINALITY, "DerivativePartyIdentification1Choice", path, "");
			})
			.collect(toList());
	}

}
