package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1BuilderImpl;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Impl;
import iso20022.auth030.fca.meta.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Meta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * A number of monetary units specified in an active or a historic currency where the unit of currency is explicit and compliant with ISO 4217. The number of fractional digits (or minor unit of currency) is not checked as per ISO 4217: It must be lesser than or equal to 13. Note: The decimal separator is a dot.
 * @version ${project.version}
 */
@RosettaDataType(value="ActiveOrHistoricCurrencyAnd13DecimalAmount__1", builder=ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1BuilderImpl.class, version="${project.version}")
public interface ActiveOrHistoricCurrencyAnd13DecimalAmount__1 extends RosettaModelObject {

	ActiveOrHistoricCurrencyAnd13DecimalAmount__1Meta metaData = new ActiveOrHistoricCurrencyAnd13DecimalAmount__1Meta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getValue();
	/**
	 * Medium of exchange of value.
	 */
	String getCcy();

	/*********************** Build Methods  ***********************/
	ActiveOrHistoricCurrencyAnd13DecimalAmount__1 build();
	
	ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder toBuilder();
	
	static ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder builder() {
		return new ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ActiveOrHistoricCurrencyAnd13DecimalAmount__1> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends ActiveOrHistoricCurrencyAnd13DecimalAmount__1> getType() {
		return ActiveOrHistoricCurrencyAnd13DecimalAmount__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("value"), BigDecimal.class, getValue(), this);
		processor.processBasic(path.newSubPath("ccy"), String.class, getCcy(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder extends ActiveOrHistoricCurrencyAnd13DecimalAmount__1, RosettaModelObjectBuilder {
		ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder setValue(BigDecimal value);
		ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder setCcy(String ccy);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("value"), BigDecimal.class, getValue(), this);
			processor.processBasic(path.newSubPath("ccy"), String.class, getCcy(), this);
		}
		

		ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder prune();
	}

	/*********************** Immutable Implementation of ActiveOrHistoricCurrencyAnd13DecimalAmount__1  ***********************/
	class ActiveOrHistoricCurrencyAnd13DecimalAmount__1Impl implements ActiveOrHistoricCurrencyAnd13DecimalAmount__1 {
		private final BigDecimal value;
		private final String ccy;
		
		protected ActiveOrHistoricCurrencyAnd13DecimalAmount__1Impl(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder builder) {
			this.value = builder.getValue();
			this.ccy = builder.getCcy();
		}
		
		@Override
		@RosettaAttribute("value")
		public BigDecimal getValue() {
			return value;
		}
		
		@Override
		@RosettaAttribute("ccy")
		public String getCcy() {
			return ccy;
		}
		
		@Override
		public ActiveOrHistoricCurrencyAnd13DecimalAmount__1 build() {
			return this;
		}
		
		@Override
		public ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder toBuilder() {
			ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder builder) {
			ofNullable(getValue()).ifPresent(builder::setValue);
			ofNullable(getCcy()).ifPresent(builder::setCcy);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ActiveOrHistoricCurrencyAnd13DecimalAmount__1 _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(ccy, _that.getCcy())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (ccy != null ? ccy.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ActiveOrHistoricCurrencyAnd13DecimalAmount__1 {" +
				"value=" + this.value + ", " +
				"ccy=" + this.ccy +
			'}';
		}
	}

	/*********************** Builder Implementation of ActiveOrHistoricCurrencyAnd13DecimalAmount__1  ***********************/
	class ActiveOrHistoricCurrencyAnd13DecimalAmount__1BuilderImpl implements ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder {
	
		protected BigDecimal value;
		protected String ccy;
		
		@Override
		@RosettaAttribute("value")
		public BigDecimal getValue() {
			return value;
		}
		
		@Override
		@RosettaAttribute("ccy")
		public String getCcy() {
			return ccy;
		}
		
		@Override
		@RosettaAttribute("value")
		public ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder setValue(BigDecimal _value) {
			this.value = _value == null ? null : _value;
			return this;
		}
		
		@Override
		@RosettaAttribute("ccy")
		public ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder setCcy(String _ccy) {
			this.ccy = _ccy == null ? null : _ccy;
			return this;
		}
		
		@Override
		public ActiveOrHistoricCurrencyAnd13DecimalAmount__1 build() {
			return new ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Impl(this);
		}
		
		@Override
		public ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getValue()!=null) return true;
			if (getCcy()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder o = (ActiveOrHistoricCurrencyAnd13DecimalAmount__1.ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder) other;
			
			
			merger.mergeBasic(getValue(), o.getValue(), this::setValue);
			merger.mergeBasic(getCcy(), o.getCcy(), this::setCcy);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ActiveOrHistoricCurrencyAnd13DecimalAmount__1 _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(ccy, _that.getCcy())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (ccy != null ? ccy.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ActiveOrHistoricCurrencyAnd13DecimalAmount__1Builder {" +
				"value=" + this.value + ", " +
				"ccy=" + this.ccy +
			'}';
		}
	}
}
