package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.ContractValuationData8__2;
import iso20022.auth030.fca.ContractValuationData8__2.ContractValuationData8__2Builder;
import iso20022.auth030.fca.CounterpartySpecificData36__5;
import iso20022.auth030.fca.CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder;
import iso20022.auth030.fca.CounterpartySpecificData36__5.CounterpartySpecificData36__5BuilderImpl;
import iso20022.auth030.fca.CounterpartySpecificData36__5.CounterpartySpecificData36__5Impl;
import iso20022.auth030.fca.TradeCounterpartyReport20__2;
import iso20022.auth030.fca.TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder;
import iso20022.auth030.fca.meta.CounterpartySpecificData36__5Meta;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Data related specifically to counterparties.
 * @version ${project.version}
 */
@RosettaDataType(value="CounterpartySpecificData36__5", builder=CounterpartySpecificData36__5.CounterpartySpecificData36__5BuilderImpl.class, version="${project.version}")
public interface CounterpartySpecificData36__5 extends RosettaModelObject {

	CounterpartySpecificData36__5Meta metaData = new CounterpartySpecificData36__5Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Data specific to counterparties of the reported transaction/position.
	 */
	TradeCounterpartyReport20__2 getCtrPty();
	/**
	 * Data specific to the valuation of the transaction.
	 */
	ContractValuationData8__2 getValtn();
	/**
	 * Indicates the date and time of the submission of the report to the trade repository.
	 */
	ZonedDateTime getRptgTmStmp();

	/*********************** Build Methods  ***********************/
	CounterpartySpecificData36__5 build();
	
	CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder toBuilder();
	
	static CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder builder() {
		return new CounterpartySpecificData36__5.CounterpartySpecificData36__5BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CounterpartySpecificData36__5> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends CounterpartySpecificData36__5> getType() {
		return CounterpartySpecificData36__5.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("ctrPty"), processor, TradeCounterpartyReport20__2.class, getCtrPty());
		processRosetta(path.newSubPath("valtn"), processor, ContractValuationData8__2.class, getValtn());
		processor.processBasic(path.newSubPath("rptgTmStmp"), ZonedDateTime.class, getRptgTmStmp(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CounterpartySpecificData36__5Builder extends CounterpartySpecificData36__5, RosettaModelObjectBuilder {
		TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder getOrCreateCtrPty();
		@Override
		TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder getCtrPty();
		ContractValuationData8__2.ContractValuationData8__2Builder getOrCreateValtn();
		@Override
		ContractValuationData8__2.ContractValuationData8__2Builder getValtn();
		CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder setCtrPty(TradeCounterpartyReport20__2 ctrPty);
		CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder setValtn(ContractValuationData8__2 valtn);
		CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder setRptgTmStmp(ZonedDateTime rptgTmStmp);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("ctrPty"), processor, TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder.class, getCtrPty());
			processRosetta(path.newSubPath("valtn"), processor, ContractValuationData8__2.ContractValuationData8__2Builder.class, getValtn());
			processor.processBasic(path.newSubPath("rptgTmStmp"), ZonedDateTime.class, getRptgTmStmp(), this);
		}
		

		CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder prune();
	}

	/*********************** Immutable Implementation of CounterpartySpecificData36__5  ***********************/
	class CounterpartySpecificData36__5Impl implements CounterpartySpecificData36__5 {
		private final TradeCounterpartyReport20__2 ctrPty;
		private final ContractValuationData8__2 valtn;
		private final ZonedDateTime rptgTmStmp;
		
		protected CounterpartySpecificData36__5Impl(CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder builder) {
			this.ctrPty = ofNullable(builder.getCtrPty()).map(f->f.build()).orElse(null);
			this.valtn = ofNullable(builder.getValtn()).map(f->f.build()).orElse(null);
			this.rptgTmStmp = builder.getRptgTmStmp();
		}
		
		@Override
		@RosettaAttribute("ctrPty")
		public TradeCounterpartyReport20__2 getCtrPty() {
			return ctrPty;
		}
		
		@Override
		@RosettaAttribute("valtn")
		public ContractValuationData8__2 getValtn() {
			return valtn;
		}
		
		@Override
		@RosettaAttribute("rptgTmStmp")
		public ZonedDateTime getRptgTmStmp() {
			return rptgTmStmp;
		}
		
		@Override
		public CounterpartySpecificData36__5 build() {
			return this;
		}
		
		@Override
		public CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder toBuilder() {
			CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder builder) {
			ofNullable(getCtrPty()).ifPresent(builder::setCtrPty);
			ofNullable(getValtn()).ifPresent(builder::setValtn);
			ofNullable(getRptgTmStmp()).ifPresent(builder::setRptgTmStmp);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CounterpartySpecificData36__5 _that = getType().cast(o);
		
			if (!Objects.equals(ctrPty, _that.getCtrPty())) return false;
			if (!Objects.equals(valtn, _that.getValtn())) return false;
			if (!Objects.equals(rptgTmStmp, _that.getRptgTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrPty != null ? ctrPty.hashCode() : 0);
			_result = 31 * _result + (valtn != null ? valtn.hashCode() : 0);
			_result = 31 * _result + (rptgTmStmp != null ? rptgTmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CounterpartySpecificData36__5 {" +
				"ctrPty=" + this.ctrPty + ", " +
				"valtn=" + this.valtn + ", " +
				"rptgTmStmp=" + this.rptgTmStmp +
			'}';
		}
	}

	/*********************** Builder Implementation of CounterpartySpecificData36__5  ***********************/
	class CounterpartySpecificData36__5BuilderImpl implements CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder {
	
		protected TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder ctrPty;
		protected ContractValuationData8__2.ContractValuationData8__2Builder valtn;
		protected ZonedDateTime rptgTmStmp;
		
		@Override
		@RosettaAttribute("ctrPty")
		public TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder getCtrPty() {
			return ctrPty;
		}
		
		@Override
		public TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder getOrCreateCtrPty() {
			TradeCounterpartyReport20__2.TradeCounterpartyReport20__2Builder result;
			if (ctrPty!=null) {
				result = ctrPty;
			}
			else {
				result = ctrPty = TradeCounterpartyReport20__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("valtn")
		public ContractValuationData8__2.ContractValuationData8__2Builder getValtn() {
			return valtn;
		}
		
		@Override
		public ContractValuationData8__2.ContractValuationData8__2Builder getOrCreateValtn() {
			ContractValuationData8__2.ContractValuationData8__2Builder result;
			if (valtn!=null) {
				result = valtn;
			}
			else {
				result = valtn = ContractValuationData8__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("rptgTmStmp")
		public ZonedDateTime getRptgTmStmp() {
			return rptgTmStmp;
		}
		
		@Override
		@RosettaAttribute("ctrPty")
		public CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder setCtrPty(TradeCounterpartyReport20__2 _ctrPty) {
			this.ctrPty = _ctrPty == null ? null : _ctrPty.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("valtn")
		public CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder setValtn(ContractValuationData8__2 _valtn) {
			this.valtn = _valtn == null ? null : _valtn.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("rptgTmStmp")
		public CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder setRptgTmStmp(ZonedDateTime _rptgTmStmp) {
			this.rptgTmStmp = _rptgTmStmp == null ? null : _rptgTmStmp;
			return this;
		}
		
		@Override
		public CounterpartySpecificData36__5 build() {
			return new CounterpartySpecificData36__5.CounterpartySpecificData36__5Impl(this);
		}
		
		@Override
		public CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder prune() {
			if (ctrPty!=null && !ctrPty.prune().hasData()) ctrPty = null;
			if (valtn!=null && !valtn.prune().hasData()) valtn = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCtrPty()!=null && getCtrPty().hasData()) return true;
			if (getValtn()!=null && getValtn().hasData()) return true;
			if (getRptgTmStmp()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder o = (CounterpartySpecificData36__5.CounterpartySpecificData36__5Builder) other;
			
			merger.mergeRosetta(getCtrPty(), o.getCtrPty(), this::setCtrPty);
			merger.mergeRosetta(getValtn(), o.getValtn(), this::setValtn);
			
			merger.mergeBasic(getRptgTmStmp(), o.getRptgTmStmp(), this::setRptgTmStmp);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CounterpartySpecificData36__5 _that = getType().cast(o);
		
			if (!Objects.equals(ctrPty, _that.getCtrPty())) return false;
			if (!Objects.equals(valtn, _that.getValtn())) return false;
			if (!Objects.equals(rptgTmStmp, _that.getRptgTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrPty != null ? ctrPty.hashCode() : 0);
			_result = 31 * _result + (valtn != null ? valtn.hashCode() : 0);
			_result = 31 * _result + (rptgTmStmp != null ? rptgTmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CounterpartySpecificData36__5Builder {" +
				"ctrPty=" + this.ctrPty + ", " +
				"valtn=" + this.valtn + ", " +
				"rptgTmStmp=" + this.rptgTmStmp +
			'}';
		}
	}
}
