package iso20022.auth030.fca.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.fca.FreightCommodityWet3__1;
import iso20022.auth030.fca.validation.FreightCommodityWet3__1TypeFormatValidator;
import iso20022.auth030.fca.validation.FreightCommodityWet3__1Validator;
import iso20022.auth030.fca.validation.exists.FreightCommodityWet3__1OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version ${project.version}
 */
@RosettaMeta(model=FreightCommodityWet3__1.class)
public class FreightCommodityWet3__1Meta implements RosettaMetaData<FreightCommodityWet3__1> {

	@Override
	public List<Validator<? super FreightCommodityWet3__1>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super FreightCommodityWet3__1, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}

	@Override
	public Validator<? super FreightCommodityWet3__1> validator() {
		return new FreightCommodityWet3__1Validator();
	}

	@Override
	public Validator<? super FreightCommodityWet3__1> typeFormatValidator() {
		return new FreightCommodityWet3__1TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super FreightCommodityWet3__1, Set<String>> onlyExistsValidator() {
		return new FreightCommodityWet3__1OnlyExistsValidator();
	}
}
