package iso20022.auth030.hkma.dtcc.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityEnvironmental3Choice;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodityEnvironmental3ChoiceChoice")
@ImplementedBy(AssetClassCommodityEnvironmental3ChoiceChoice.Default.class)
public interface AssetClassCommodityEnvironmental3ChoiceChoice extends Validator<AssetClassCommodityEnvironmental3Choice> {
	
	String NAME = "AssetClassCommodityEnvironmental3ChoiceChoice";
	String DEFINITION = "one-of";
	
	ValidationResult<AssetClassCommodityEnvironmental3Choice> validate(RosettaPath path, AssetClassCommodityEnvironmental3Choice assetClassCommodityEnvironmental3Choice);
	
	class Default implements AssetClassCommodityEnvironmental3ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityEnvironmental3Choice> validate(RosettaPath path, AssetClassCommodityEnvironmental3Choice assetClassCommodityEnvironmental3Choice) {
			ComparisonResult result = executeDataRule(assetClassCommodityEnvironmental3Choice);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityEnvironmental3Choice", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AssetClassCommodityEnvironmental3Choice", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodityEnvironmental3Choice assetClassCommodityEnvironmental3Choice) {
			try {
				return choice(MapperS.of(assetClassCommodityEnvironmental3Choice), Arrays.asList("emssns", "wthr", "crbnRltd", "othr"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodityEnvironmental3ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityEnvironmental3Choice> validate(RosettaPath path, AssetClassCommodityEnvironmental3Choice assetClassCommodityEnvironmental3Choice) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityEnvironmental3Choice", path, DEFINITION);
		}
	}
}
