package iso20022.auth030.hkma.dtcc.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.AssetClassCommodityPolypropylene4Choice;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodityPolypropylene4ChoiceChoice")
@ImplementedBy(AssetClassCommodityPolypropylene4ChoiceChoice.Default.class)
public interface AssetClassCommodityPolypropylene4ChoiceChoice extends Validator<AssetClassCommodityPolypropylene4Choice> {
	
	String NAME = "AssetClassCommodityPolypropylene4ChoiceChoice";
	String DEFINITION = "one-of";
	
	ValidationResult<AssetClassCommodityPolypropylene4Choice> validate(RosettaPath path, AssetClassCommodityPolypropylene4Choice assetClassCommodityPolypropylene4Choice);
	
	class Default implements AssetClassCommodityPolypropylene4ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityPolypropylene4Choice> validate(RosettaPath path, AssetClassCommodityPolypropylene4Choice assetClassCommodityPolypropylene4Choice) {
			ComparisonResult result = executeDataRule(assetClassCommodityPolypropylene4Choice);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityPolypropylene4Choice", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AssetClassCommodityPolypropylene4Choice", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodityPolypropylene4Choice assetClassCommodityPolypropylene4Choice) {
			try {
				return choice(MapperS.of(assetClassCommodityPolypropylene4Choice), Arrays.asList("plstc", "othr"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodityPolypropylene4ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityPolypropylene4Choice> validate(RosettaPath path, AssetClassCommodityPolypropylene4Choice assetClassCommodityPolypropylene4Choice) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityPolypropylene4Choice", path, DEFINITION);
		}
	}
}
