package iso20022.auth030.hkma.dtcc.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.QuantityOrTerm1Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("QuantityOrTerm1Choice__1Choice")
@ImplementedBy(QuantityOrTerm1Choice1Choice.Default.class)
public interface QuantityOrTerm1Choice1Choice extends Validator<QuantityOrTerm1Choice__1> {
	
	String NAME = "QuantityOrTerm1Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<QuantityOrTerm1Choice__1> validate(RosettaPath path, QuantityOrTerm1Choice__1 quantityOrTerm1Choice__1);
	
	class Default implements QuantityOrTerm1Choice1Choice {
	
		@Override
		public ValidationResult<QuantityOrTerm1Choice__1> validate(RosettaPath path, QuantityOrTerm1Choice__1 quantityOrTerm1Choice__1) {
			ComparisonResult result = executeDataRule(quantityOrTerm1Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "QuantityOrTerm1Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "QuantityOrTerm1Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(QuantityOrTerm1Choice__1 quantityOrTerm1Choice__1) {
			try {
				return choice(MapperS.of(quantityOrTerm1Choice__1), Arrays.asList("schdlPrd", "term"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements QuantityOrTerm1Choice1Choice {
	
		@Override
		public ValidationResult<QuantityOrTerm1Choice__1> validate(RosettaPath path, QuantityOrTerm1Choice__1 quantityOrTerm1Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "QuantityOrTerm1Choice__1", path, DEFINITION);
		}
	}
}
