package iso20022.auth030.jfsa;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.jfsa.ContractType15__2;
import iso20022.auth030.jfsa.ContractType15__2.ContractType15__2Builder;
import iso20022.auth030.jfsa.ContractType15__2.ContractType15__2BuilderImpl;
import iso20022.auth030.jfsa.ContractType15__2.ContractType15__2Impl;
import iso20022.auth030.jfsa.CurrencyExchange23__1;
import iso20022.auth030.jfsa.CurrencyExchange23__1.CurrencyExchange23__1Builder;
import iso20022.auth030.jfsa.FinancialInstrumentContractType2Code;
import iso20022.auth030.jfsa.ProductType4Code__1;
import iso20022.auth030.jfsa.SecurityIdentification41Choice__1;
import iso20022.auth030.jfsa.SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder;
import iso20022.auth030.jfsa.SecurityIdentification46__1;
import iso20022.auth030.jfsa.SecurityIdentification46__1.SecurityIdentification46__1Builder;
import iso20022.auth030.jfsa.meta.ContractType15__2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version ${project.version}
 */
@RosettaDataType(value="ContractType15__2", builder=ContractType15__2.ContractType15__2BuilderImpl.class, version="${project.version}")
public interface ContractType15__2 extends RosettaModelObject {

	ContractType15__2Meta metaData = new ContractType15__2Meta();

	/*********************** Getter Methods  ***********************/
	FinancialInstrumentContractType2Code getCtrctTp();
	ProductType4Code__1 getAsstClss();
	SecurityIdentification46__1 getPdctId();
	SecurityIdentification41Choice__1 getUndrlygInstrm();
	CurrencyExchange23__1 getSttlmCcy();
	CurrencyExchange23__1 getSttlmCcyScndLeg();
	Boolean getDerivBasedOnCrptAsst();

	/*********************** Build Methods  ***********************/
	ContractType15__2 build();
	
	ContractType15__2.ContractType15__2Builder toBuilder();
	
	static ContractType15__2.ContractType15__2Builder builder() {
		return new ContractType15__2.ContractType15__2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ContractType15__2> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends ContractType15__2> getType() {
		return ContractType15__2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("ctrctTp"), FinancialInstrumentContractType2Code.class, getCtrctTp(), this);
		processor.processBasic(path.newSubPath("asstClss"), ProductType4Code__1.class, getAsstClss(), this);
		processRosetta(path.newSubPath("pdctId"), processor, SecurityIdentification46__1.class, getPdctId());
		processRosetta(path.newSubPath("undrlygInstrm"), processor, SecurityIdentification41Choice__1.class, getUndrlygInstrm());
		processRosetta(path.newSubPath("sttlmCcy"), processor, CurrencyExchange23__1.class, getSttlmCcy());
		processRosetta(path.newSubPath("sttlmCcyScndLeg"), processor, CurrencyExchange23__1.class, getSttlmCcyScndLeg());
		processor.processBasic(path.newSubPath("derivBasedOnCrptAsst"), Boolean.class, getDerivBasedOnCrptAsst(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ContractType15__2Builder extends ContractType15__2, RosettaModelObjectBuilder {
		SecurityIdentification46__1.SecurityIdentification46__1Builder getOrCreatePdctId();
		@Override
		SecurityIdentification46__1.SecurityIdentification46__1Builder getPdctId();
		SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder getOrCreateUndrlygInstrm();
		@Override
		SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder getUndrlygInstrm();
		CurrencyExchange23__1.CurrencyExchange23__1Builder getOrCreateSttlmCcy();
		@Override
		CurrencyExchange23__1.CurrencyExchange23__1Builder getSttlmCcy();
		CurrencyExchange23__1.CurrencyExchange23__1Builder getOrCreateSttlmCcyScndLeg();
		@Override
		CurrencyExchange23__1.CurrencyExchange23__1Builder getSttlmCcyScndLeg();
		ContractType15__2.ContractType15__2Builder setCtrctTp(FinancialInstrumentContractType2Code ctrctTp);
		ContractType15__2.ContractType15__2Builder setAsstClss(ProductType4Code__1 asstClss);
		ContractType15__2.ContractType15__2Builder setPdctId(SecurityIdentification46__1 pdctId);
		ContractType15__2.ContractType15__2Builder setUndrlygInstrm(SecurityIdentification41Choice__1 undrlygInstrm);
		ContractType15__2.ContractType15__2Builder setSttlmCcy(CurrencyExchange23__1 sttlmCcy);
		ContractType15__2.ContractType15__2Builder setSttlmCcyScndLeg(CurrencyExchange23__1 sttlmCcyScndLeg);
		ContractType15__2.ContractType15__2Builder setDerivBasedOnCrptAsst(Boolean derivBasedOnCrptAsst);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("ctrctTp"), FinancialInstrumentContractType2Code.class, getCtrctTp(), this);
			processor.processBasic(path.newSubPath("asstClss"), ProductType4Code__1.class, getAsstClss(), this);
			processRosetta(path.newSubPath("pdctId"), processor, SecurityIdentification46__1.SecurityIdentification46__1Builder.class, getPdctId());
			processRosetta(path.newSubPath("undrlygInstrm"), processor, SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder.class, getUndrlygInstrm());
			processRosetta(path.newSubPath("sttlmCcy"), processor, CurrencyExchange23__1.CurrencyExchange23__1Builder.class, getSttlmCcy());
			processRosetta(path.newSubPath("sttlmCcyScndLeg"), processor, CurrencyExchange23__1.CurrencyExchange23__1Builder.class, getSttlmCcyScndLeg());
			processor.processBasic(path.newSubPath("derivBasedOnCrptAsst"), Boolean.class, getDerivBasedOnCrptAsst(), this);
		}
		

		ContractType15__2.ContractType15__2Builder prune();
	}

	/*********************** Immutable Implementation of ContractType15__2  ***********************/
	class ContractType15__2Impl implements ContractType15__2 {
		private final FinancialInstrumentContractType2Code ctrctTp;
		private final ProductType4Code__1 asstClss;
		private final SecurityIdentification46__1 pdctId;
		private final SecurityIdentification41Choice__1 undrlygInstrm;
		private final CurrencyExchange23__1 sttlmCcy;
		private final CurrencyExchange23__1 sttlmCcyScndLeg;
		private final Boolean derivBasedOnCrptAsst;
		
		protected ContractType15__2Impl(ContractType15__2.ContractType15__2Builder builder) {
			this.ctrctTp = builder.getCtrctTp();
			this.asstClss = builder.getAsstClss();
			this.pdctId = ofNullable(builder.getPdctId()).map(f->f.build()).orElse(null);
			this.undrlygInstrm = ofNullable(builder.getUndrlygInstrm()).map(f->f.build()).orElse(null);
			this.sttlmCcy = ofNullable(builder.getSttlmCcy()).map(f->f.build()).orElse(null);
			this.sttlmCcyScndLeg = ofNullable(builder.getSttlmCcyScndLeg()).map(f->f.build()).orElse(null);
			this.derivBasedOnCrptAsst = builder.getDerivBasedOnCrptAsst();
		}
		
		@Override
		@RosettaAttribute("ctrctTp")
		public FinancialInstrumentContractType2Code getCtrctTp() {
			return ctrctTp;
		}
		
		@Override
		@RosettaAttribute("asstClss")
		public ProductType4Code__1 getAsstClss() {
			return asstClss;
		}
		
		@Override
		@RosettaAttribute("pdctId")
		public SecurityIdentification46__1 getPdctId() {
			return pdctId;
		}
		
		@Override
		@RosettaAttribute("undrlygInstrm")
		public SecurityIdentification41Choice__1 getUndrlygInstrm() {
			return undrlygInstrm;
		}
		
		@Override
		@RosettaAttribute("sttlmCcy")
		public CurrencyExchange23__1 getSttlmCcy() {
			return sttlmCcy;
		}
		
		@Override
		@RosettaAttribute("sttlmCcyScndLeg")
		public CurrencyExchange23__1 getSttlmCcyScndLeg() {
			return sttlmCcyScndLeg;
		}
		
		@Override
		@RosettaAttribute("derivBasedOnCrptAsst")
		public Boolean getDerivBasedOnCrptAsst() {
			return derivBasedOnCrptAsst;
		}
		
		@Override
		public ContractType15__2 build() {
			return this;
		}
		
		@Override
		public ContractType15__2.ContractType15__2Builder toBuilder() {
			ContractType15__2.ContractType15__2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ContractType15__2.ContractType15__2Builder builder) {
			ofNullable(getCtrctTp()).ifPresent(builder::setCtrctTp);
			ofNullable(getAsstClss()).ifPresent(builder::setAsstClss);
			ofNullable(getPdctId()).ifPresent(builder::setPdctId);
			ofNullable(getUndrlygInstrm()).ifPresent(builder::setUndrlygInstrm);
			ofNullable(getSttlmCcy()).ifPresent(builder::setSttlmCcy);
			ofNullable(getSttlmCcyScndLeg()).ifPresent(builder::setSttlmCcyScndLeg);
			ofNullable(getDerivBasedOnCrptAsst()).ifPresent(builder::setDerivBasedOnCrptAsst);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ContractType15__2 _that = getType().cast(o);
		
			if (!Objects.equals(ctrctTp, _that.getCtrctTp())) return false;
			if (!Objects.equals(asstClss, _that.getAsstClss())) return false;
			if (!Objects.equals(pdctId, _that.getPdctId())) return false;
			if (!Objects.equals(undrlygInstrm, _that.getUndrlygInstrm())) return false;
			if (!Objects.equals(sttlmCcy, _that.getSttlmCcy())) return false;
			if (!Objects.equals(sttlmCcyScndLeg, _that.getSttlmCcyScndLeg())) return false;
			if (!Objects.equals(derivBasedOnCrptAsst, _that.getDerivBasedOnCrptAsst())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrctTp != null ? ctrctTp.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (asstClss != null ? asstClss.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (pdctId != null ? pdctId.hashCode() : 0);
			_result = 31 * _result + (undrlygInstrm != null ? undrlygInstrm.hashCode() : 0);
			_result = 31 * _result + (sttlmCcy != null ? sttlmCcy.hashCode() : 0);
			_result = 31 * _result + (sttlmCcyScndLeg != null ? sttlmCcyScndLeg.hashCode() : 0);
			_result = 31 * _result + (derivBasedOnCrptAsst != null ? derivBasedOnCrptAsst.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ContractType15__2 {" +
				"ctrctTp=" + this.ctrctTp + ", " +
				"asstClss=" + this.asstClss + ", " +
				"pdctId=" + this.pdctId + ", " +
				"undrlygInstrm=" + this.undrlygInstrm + ", " +
				"sttlmCcy=" + this.sttlmCcy + ", " +
				"sttlmCcyScndLeg=" + this.sttlmCcyScndLeg + ", " +
				"derivBasedOnCrptAsst=" + this.derivBasedOnCrptAsst +
			'}';
		}
	}

	/*********************** Builder Implementation of ContractType15__2  ***********************/
	class ContractType15__2BuilderImpl implements ContractType15__2.ContractType15__2Builder {
	
		protected FinancialInstrumentContractType2Code ctrctTp;
		protected ProductType4Code__1 asstClss;
		protected SecurityIdentification46__1.SecurityIdentification46__1Builder pdctId;
		protected SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder undrlygInstrm;
		protected CurrencyExchange23__1.CurrencyExchange23__1Builder sttlmCcy;
		protected CurrencyExchange23__1.CurrencyExchange23__1Builder sttlmCcyScndLeg;
		protected Boolean derivBasedOnCrptAsst;
		
		@Override
		@RosettaAttribute("ctrctTp")
		public FinancialInstrumentContractType2Code getCtrctTp() {
			return ctrctTp;
		}
		
		@Override
		@RosettaAttribute("asstClss")
		public ProductType4Code__1 getAsstClss() {
			return asstClss;
		}
		
		@Override
		@RosettaAttribute("pdctId")
		public SecurityIdentification46__1.SecurityIdentification46__1Builder getPdctId() {
			return pdctId;
		}
		
		@Override
		public SecurityIdentification46__1.SecurityIdentification46__1Builder getOrCreatePdctId() {
			SecurityIdentification46__1.SecurityIdentification46__1Builder result;
			if (pdctId!=null) {
				result = pdctId;
			}
			else {
				result = pdctId = SecurityIdentification46__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("undrlygInstrm")
		public SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder getUndrlygInstrm() {
			return undrlygInstrm;
		}
		
		@Override
		public SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder getOrCreateUndrlygInstrm() {
			SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder result;
			if (undrlygInstrm!=null) {
				result = undrlygInstrm;
			}
			else {
				result = undrlygInstrm = SecurityIdentification41Choice__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("sttlmCcy")
		public CurrencyExchange23__1.CurrencyExchange23__1Builder getSttlmCcy() {
			return sttlmCcy;
		}
		
		@Override
		public CurrencyExchange23__1.CurrencyExchange23__1Builder getOrCreateSttlmCcy() {
			CurrencyExchange23__1.CurrencyExchange23__1Builder result;
			if (sttlmCcy!=null) {
				result = sttlmCcy;
			}
			else {
				result = sttlmCcy = CurrencyExchange23__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("sttlmCcyScndLeg")
		public CurrencyExchange23__1.CurrencyExchange23__1Builder getSttlmCcyScndLeg() {
			return sttlmCcyScndLeg;
		}
		
		@Override
		public CurrencyExchange23__1.CurrencyExchange23__1Builder getOrCreateSttlmCcyScndLeg() {
			CurrencyExchange23__1.CurrencyExchange23__1Builder result;
			if (sttlmCcyScndLeg!=null) {
				result = sttlmCcyScndLeg;
			}
			else {
				result = sttlmCcyScndLeg = CurrencyExchange23__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("derivBasedOnCrptAsst")
		public Boolean getDerivBasedOnCrptAsst() {
			return derivBasedOnCrptAsst;
		}
		
		@Override
		@RosettaAttribute("ctrctTp")
		public ContractType15__2.ContractType15__2Builder setCtrctTp(FinancialInstrumentContractType2Code _ctrctTp) {
			this.ctrctTp = _ctrctTp == null ? null : _ctrctTp;
			return this;
		}
		
		@Override
		@RosettaAttribute("asstClss")
		public ContractType15__2.ContractType15__2Builder setAsstClss(ProductType4Code__1 _asstClss) {
			this.asstClss = _asstClss == null ? null : _asstClss;
			return this;
		}
		
		@Override
		@RosettaAttribute("pdctId")
		public ContractType15__2.ContractType15__2Builder setPdctId(SecurityIdentification46__1 _pdctId) {
			this.pdctId = _pdctId == null ? null : _pdctId.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("undrlygInstrm")
		public ContractType15__2.ContractType15__2Builder setUndrlygInstrm(SecurityIdentification41Choice__1 _undrlygInstrm) {
			this.undrlygInstrm = _undrlygInstrm == null ? null : _undrlygInstrm.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("sttlmCcy")
		public ContractType15__2.ContractType15__2Builder setSttlmCcy(CurrencyExchange23__1 _sttlmCcy) {
			this.sttlmCcy = _sttlmCcy == null ? null : _sttlmCcy.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("sttlmCcyScndLeg")
		public ContractType15__2.ContractType15__2Builder setSttlmCcyScndLeg(CurrencyExchange23__1 _sttlmCcyScndLeg) {
			this.sttlmCcyScndLeg = _sttlmCcyScndLeg == null ? null : _sttlmCcyScndLeg.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("derivBasedOnCrptAsst")
		public ContractType15__2.ContractType15__2Builder setDerivBasedOnCrptAsst(Boolean _derivBasedOnCrptAsst) {
			this.derivBasedOnCrptAsst = _derivBasedOnCrptAsst == null ? null : _derivBasedOnCrptAsst;
			return this;
		}
		
		@Override
		public ContractType15__2 build() {
			return new ContractType15__2.ContractType15__2Impl(this);
		}
		
		@Override
		public ContractType15__2.ContractType15__2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ContractType15__2.ContractType15__2Builder prune() {
			if (pdctId!=null && !pdctId.prune().hasData()) pdctId = null;
			if (undrlygInstrm!=null && !undrlygInstrm.prune().hasData()) undrlygInstrm = null;
			if (sttlmCcy!=null && !sttlmCcy.prune().hasData()) sttlmCcy = null;
			if (sttlmCcyScndLeg!=null && !sttlmCcyScndLeg.prune().hasData()) sttlmCcyScndLeg = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCtrctTp()!=null) return true;
			if (getAsstClss()!=null) return true;
			if (getPdctId()!=null && getPdctId().hasData()) return true;
			if (getUndrlygInstrm()!=null && getUndrlygInstrm().hasData()) return true;
			if (getSttlmCcy()!=null && getSttlmCcy().hasData()) return true;
			if (getSttlmCcyScndLeg()!=null && getSttlmCcyScndLeg().hasData()) return true;
			if (getDerivBasedOnCrptAsst()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ContractType15__2.ContractType15__2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ContractType15__2.ContractType15__2Builder o = (ContractType15__2.ContractType15__2Builder) other;
			
			merger.mergeRosetta(getPdctId(), o.getPdctId(), this::setPdctId);
			merger.mergeRosetta(getUndrlygInstrm(), o.getUndrlygInstrm(), this::setUndrlygInstrm);
			merger.mergeRosetta(getSttlmCcy(), o.getSttlmCcy(), this::setSttlmCcy);
			merger.mergeRosetta(getSttlmCcyScndLeg(), o.getSttlmCcyScndLeg(), this::setSttlmCcyScndLeg);
			
			merger.mergeBasic(getCtrctTp(), o.getCtrctTp(), this::setCtrctTp);
			merger.mergeBasic(getAsstClss(), o.getAsstClss(), this::setAsstClss);
			merger.mergeBasic(getDerivBasedOnCrptAsst(), o.getDerivBasedOnCrptAsst(), this::setDerivBasedOnCrptAsst);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ContractType15__2 _that = getType().cast(o);
		
			if (!Objects.equals(ctrctTp, _that.getCtrctTp())) return false;
			if (!Objects.equals(asstClss, _that.getAsstClss())) return false;
			if (!Objects.equals(pdctId, _that.getPdctId())) return false;
			if (!Objects.equals(undrlygInstrm, _that.getUndrlygInstrm())) return false;
			if (!Objects.equals(sttlmCcy, _that.getSttlmCcy())) return false;
			if (!Objects.equals(sttlmCcyScndLeg, _that.getSttlmCcyScndLeg())) return false;
			if (!Objects.equals(derivBasedOnCrptAsst, _that.getDerivBasedOnCrptAsst())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrctTp != null ? ctrctTp.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (asstClss != null ? asstClss.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (pdctId != null ? pdctId.hashCode() : 0);
			_result = 31 * _result + (undrlygInstrm != null ? undrlygInstrm.hashCode() : 0);
			_result = 31 * _result + (sttlmCcy != null ? sttlmCcy.hashCode() : 0);
			_result = 31 * _result + (sttlmCcyScndLeg != null ? sttlmCcyScndLeg.hashCode() : 0);
			_result = 31 * _result + (derivBasedOnCrptAsst != null ? derivBasedOnCrptAsst.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ContractType15__2Builder {" +
				"ctrctTp=" + this.ctrctTp + ", " +
				"asstClss=" + this.asstClss + ", " +
				"pdctId=" + this.pdctId + ", " +
				"undrlygInstrm=" + this.undrlygInstrm + ", " +
				"sttlmCcy=" + this.sttlmCcy + ", " +
				"sttlmCcyScndLeg=" + this.sttlmCcyScndLeg + ", " +
				"derivBasedOnCrptAsst=" + this.derivBasedOnCrptAsst +
			'}';
		}
	}
}
