package iso20022.auth030.jfsa;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.jfsa.AmountAndDirection106__2;
import iso20022.auth030.jfsa.AmountAndDirection106__2.AmountAndDirection106__2Builder;
import iso20022.auth030.jfsa.NotionalAmount6__2;
import iso20022.auth030.jfsa.NotionalAmount6__2.NotionalAmount6__2Builder;
import iso20022.auth030.jfsa.NotionalAmount6__2.NotionalAmount6__2BuilderImpl;
import iso20022.auth030.jfsa.NotionalAmount6__2.NotionalAmount6__2Impl;
import iso20022.auth030.jfsa.meta.NotionalAmount6__2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version ${project.version}
 */
@RosettaDataType(value="NotionalAmount6__2", builder=NotionalAmount6__2.NotionalAmount6__2BuilderImpl.class, version="${project.version}")
public interface NotionalAmount6__2 extends RosettaModelObject {

	NotionalAmount6__2Meta metaData = new NotionalAmount6__2Meta();

	/*********************** Getter Methods  ***********************/
	AmountAndDirection106__2 getAmt();

	/*********************** Build Methods  ***********************/
	NotionalAmount6__2 build();
	
	NotionalAmount6__2.NotionalAmount6__2Builder toBuilder();
	
	static NotionalAmount6__2.NotionalAmount6__2Builder builder() {
		return new NotionalAmount6__2.NotionalAmount6__2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends NotionalAmount6__2> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends NotionalAmount6__2> getType() {
		return NotionalAmount6__2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("amt"), processor, AmountAndDirection106__2.class, getAmt());
	}
	

	/*********************** Builder Interface  ***********************/
	interface NotionalAmount6__2Builder extends NotionalAmount6__2, RosettaModelObjectBuilder {
		AmountAndDirection106__2.AmountAndDirection106__2Builder getOrCreateAmt();
		@Override
		AmountAndDirection106__2.AmountAndDirection106__2Builder getAmt();
		NotionalAmount6__2.NotionalAmount6__2Builder setAmt(AmountAndDirection106__2 amt);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("amt"), processor, AmountAndDirection106__2.AmountAndDirection106__2Builder.class, getAmt());
		}
		

		NotionalAmount6__2.NotionalAmount6__2Builder prune();
	}

	/*********************** Immutable Implementation of NotionalAmount6__2  ***********************/
	class NotionalAmount6__2Impl implements NotionalAmount6__2 {
		private final AmountAndDirection106__2 amt;
		
		protected NotionalAmount6__2Impl(NotionalAmount6__2.NotionalAmount6__2Builder builder) {
			this.amt = ofNullable(builder.getAmt()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("amt")
		public AmountAndDirection106__2 getAmt() {
			return amt;
		}
		
		@Override
		public NotionalAmount6__2 build() {
			return this;
		}
		
		@Override
		public NotionalAmount6__2.NotionalAmount6__2Builder toBuilder() {
			NotionalAmount6__2.NotionalAmount6__2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(NotionalAmount6__2.NotionalAmount6__2Builder builder) {
			ofNullable(getAmt()).ifPresent(builder::setAmt);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NotionalAmount6__2 _that = getType().cast(o);
		
			if (!Objects.equals(amt, _that.getAmt())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amt != null ? amt.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NotionalAmount6__2 {" +
				"amt=" + this.amt +
			'}';
		}
	}

	/*********************** Builder Implementation of NotionalAmount6__2  ***********************/
	class NotionalAmount6__2BuilderImpl implements NotionalAmount6__2.NotionalAmount6__2Builder {
	
		protected AmountAndDirection106__2.AmountAndDirection106__2Builder amt;
		
		@Override
		@RosettaAttribute("amt")
		public AmountAndDirection106__2.AmountAndDirection106__2Builder getAmt() {
			return amt;
		}
		
		@Override
		public AmountAndDirection106__2.AmountAndDirection106__2Builder getOrCreateAmt() {
			AmountAndDirection106__2.AmountAndDirection106__2Builder result;
			if (amt!=null) {
				result = amt;
			}
			else {
				result = amt = AmountAndDirection106__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("amt")
		public NotionalAmount6__2.NotionalAmount6__2Builder setAmt(AmountAndDirection106__2 _amt) {
			this.amt = _amt == null ? null : _amt.toBuilder();
			return this;
		}
		
		@Override
		public NotionalAmount6__2 build() {
			return new NotionalAmount6__2.NotionalAmount6__2Impl(this);
		}
		
		@Override
		public NotionalAmount6__2.NotionalAmount6__2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NotionalAmount6__2.NotionalAmount6__2Builder prune() {
			if (amt!=null && !amt.prune().hasData()) amt = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getAmt()!=null && getAmt().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NotionalAmount6__2.NotionalAmount6__2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			NotionalAmount6__2.NotionalAmount6__2Builder o = (NotionalAmount6__2.NotionalAmount6__2Builder) other;
			
			merger.mergeRosetta(getAmt(), o.getAmt(), this::setAmt);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NotionalAmount6__2 _that = getType().cast(o);
		
			if (!Objects.equals(amt, _that.getAmt())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amt != null ? amt.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NotionalAmount6__2Builder {" +
				"amt=" + this.amt +
			'}';
		}
	}
}
