package iso20022.auth030.jfsa;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import iso20022.auth030.jfsa.CollateralPortfolioCode6Choice__1;
import iso20022.auth030.jfsa.CollateralPortfolioCode6Choice__1.CollateralPortfolioCode6Choice__1Builder;
import iso20022.auth030.jfsa.CreditDerivative4__1;
import iso20022.auth030.jfsa.CreditDerivative4__1.CreditDerivative4__1Builder;
import iso20022.auth030.jfsa.CurrencyExchange22__1;
import iso20022.auth030.jfsa.CurrencyExchange22__1.CurrencyExchange22__1Builder;
import iso20022.auth030.jfsa.DerivativeEvent6__2;
import iso20022.auth030.jfsa.DerivativeEvent6__2.DerivativeEvent6__2Builder;
import iso20022.auth030.jfsa.InterestRateLegs14__3;
import iso20022.auth030.jfsa.InterestRateLegs14__3.InterestRateLegs14__3Builder;
import iso20022.auth030.jfsa.NotionalAmountLegs5__2;
import iso20022.auth030.jfsa.NotionalAmountLegs5__2.NotionalAmountLegs5__2Builder;
import iso20022.auth030.jfsa.NotionalQuantityLegs5__2;
import iso20022.auth030.jfsa.NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder;
import iso20022.auth030.jfsa.OptionOrSwaption11__2;
import iso20022.auth030.jfsa.OptionOrSwaption11__2.OptionOrSwaption11__2Builder;
import iso20022.auth030.jfsa.OtherPayment5__1;
import iso20022.auth030.jfsa.OtherPayment5__1.OtherPayment5__1Builder;
import iso20022.auth030.jfsa.Package4__1;
import iso20022.auth030.jfsa.Package4__1.Package4__1Builder;
import iso20022.auth030.jfsa.PhysicalTransferType4Code;
import iso20022.auth030.jfsa.PriceData2__2;
import iso20022.auth030.jfsa.PriceData2__2.PriceData2__2Builder;
import iso20022.auth030.jfsa.TradeClearing11__2;
import iso20022.auth030.jfsa.TradeClearing11__2.TradeClearing11__2Builder;
import iso20022.auth030.jfsa.TradeConfirmation4Choice;
import iso20022.auth030.jfsa.TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder;
import iso20022.auth030.jfsa.TradeTransaction50__6;
import iso20022.auth030.jfsa.TradeTransaction50__6.TradeTransaction50__6Builder;
import iso20022.auth030.jfsa.TradeTransaction50__6.TradeTransaction50__6BuilderImpl;
import iso20022.auth030.jfsa.TradeTransaction50__6.TradeTransaction50__6Impl;
import iso20022.auth030.jfsa.UniqueTransactionIdentifier2Choice__1;
import iso20022.auth030.jfsa.UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder;
import iso20022.auth030.jfsa.meta.TradeTransaction50__6Meta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version ${project.version}
 */
@RosettaDataType(value="TradeTransaction50__6", builder=TradeTransaction50__6.TradeTransaction50__6BuilderImpl.class, version="${project.version}")
public interface TradeTransaction50__6 extends RosettaModelObject {

	TradeTransaction50__6Meta metaData = new TradeTransaction50__6Meta();

	/*********************** Getter Methods  ***********************/
	UniqueTransactionIdentifier2Choice__1 getTxId();
	CollateralPortfolioCode6Choice__1 getCollPrtflCd();
	String getPltfmIdr();
	PriceData2__2 getTxPric();
	NotionalAmountLegs5__2 getNtnlAmt();
	NotionalQuantityLegs5__2 getNtnlQty();
	PhysicalTransferType4Code getDlvryTp();
	ZonedDateTime getExctnTmStmp();
	Date getFctvDt();
	Date getXprtnDt();
	Date getSttlmDt();
	DerivativeEvent6__2 getDerivEvt();
	TradeConfirmation4Choice getTradConf();
	TradeClearing11__2 getTradClr();
	InterestRateLegs14__3 getIntrstRate();
	CurrencyExchange22__1 getCcy();
	OptionOrSwaption11__2 getOptn();
	CreditDerivative4__1 getCdt();
	List<? extends OtherPayment5__1> getOthrPmt();
	Package4__1 getPackg();

	/*********************** Build Methods  ***********************/
	TradeTransaction50__6 build();
	
	TradeTransaction50__6.TradeTransaction50__6Builder toBuilder();
	
	static TradeTransaction50__6.TradeTransaction50__6Builder builder() {
		return new TradeTransaction50__6.TradeTransaction50__6BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends TradeTransaction50__6> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends TradeTransaction50__6> getType() {
		return TradeTransaction50__6.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("txId"), processor, UniqueTransactionIdentifier2Choice__1.class, getTxId());
		processRosetta(path.newSubPath("collPrtflCd"), processor, CollateralPortfolioCode6Choice__1.class, getCollPrtflCd());
		processor.processBasic(path.newSubPath("pltfmIdr"), String.class, getPltfmIdr(), this);
		processRosetta(path.newSubPath("txPric"), processor, PriceData2__2.class, getTxPric());
		processRosetta(path.newSubPath("ntnlAmt"), processor, NotionalAmountLegs5__2.class, getNtnlAmt());
		processRosetta(path.newSubPath("ntnlQty"), processor, NotionalQuantityLegs5__2.class, getNtnlQty());
		processor.processBasic(path.newSubPath("dlvryTp"), PhysicalTransferType4Code.class, getDlvryTp(), this);
		processor.processBasic(path.newSubPath("exctnTmStmp"), ZonedDateTime.class, getExctnTmStmp(), this);
		processor.processBasic(path.newSubPath("fctvDt"), Date.class, getFctvDt(), this);
		processor.processBasic(path.newSubPath("xprtnDt"), Date.class, getXprtnDt(), this);
		processor.processBasic(path.newSubPath("sttlmDt"), Date.class, getSttlmDt(), this);
		processRosetta(path.newSubPath("derivEvt"), processor, DerivativeEvent6__2.class, getDerivEvt());
		processRosetta(path.newSubPath("tradConf"), processor, TradeConfirmation4Choice.class, getTradConf());
		processRosetta(path.newSubPath("tradClr"), processor, TradeClearing11__2.class, getTradClr());
		processRosetta(path.newSubPath("intrstRate"), processor, InterestRateLegs14__3.class, getIntrstRate());
		processRosetta(path.newSubPath("ccy"), processor, CurrencyExchange22__1.class, getCcy());
		processRosetta(path.newSubPath("optn"), processor, OptionOrSwaption11__2.class, getOptn());
		processRosetta(path.newSubPath("cdt"), processor, CreditDerivative4__1.class, getCdt());
		processRosetta(path.newSubPath("othrPmt"), processor, OtherPayment5__1.class, getOthrPmt());
		processRosetta(path.newSubPath("packg"), processor, Package4__1.class, getPackg());
	}
	

	/*********************** Builder Interface  ***********************/
	interface TradeTransaction50__6Builder extends TradeTransaction50__6, RosettaModelObjectBuilder {
		UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder getOrCreateTxId();
		@Override
		UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder getTxId();
		CollateralPortfolioCode6Choice__1.CollateralPortfolioCode6Choice__1Builder getOrCreateCollPrtflCd();
		@Override
		CollateralPortfolioCode6Choice__1.CollateralPortfolioCode6Choice__1Builder getCollPrtflCd();
		PriceData2__2.PriceData2__2Builder getOrCreateTxPric();
		@Override
		PriceData2__2.PriceData2__2Builder getTxPric();
		NotionalAmountLegs5__2.NotionalAmountLegs5__2Builder getOrCreateNtnlAmt();
		@Override
		NotionalAmountLegs5__2.NotionalAmountLegs5__2Builder getNtnlAmt();
		NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder getOrCreateNtnlQty();
		@Override
		NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder getNtnlQty();
		DerivativeEvent6__2.DerivativeEvent6__2Builder getOrCreateDerivEvt();
		@Override
		DerivativeEvent6__2.DerivativeEvent6__2Builder getDerivEvt();
		TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder getOrCreateTradConf();
		@Override
		TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder getTradConf();
		TradeClearing11__2.TradeClearing11__2Builder getOrCreateTradClr();
		@Override
		TradeClearing11__2.TradeClearing11__2Builder getTradClr();
		InterestRateLegs14__3.InterestRateLegs14__3Builder getOrCreateIntrstRate();
		@Override
		InterestRateLegs14__3.InterestRateLegs14__3Builder getIntrstRate();
		CurrencyExchange22__1.CurrencyExchange22__1Builder getOrCreateCcy();
		@Override
		CurrencyExchange22__1.CurrencyExchange22__1Builder getCcy();
		OptionOrSwaption11__2.OptionOrSwaption11__2Builder getOrCreateOptn();
		@Override
		OptionOrSwaption11__2.OptionOrSwaption11__2Builder getOptn();
		CreditDerivative4__1.CreditDerivative4__1Builder getOrCreateCdt();
		@Override
		CreditDerivative4__1.CreditDerivative4__1Builder getCdt();
		OtherPayment5__1.OtherPayment5__1Builder getOrCreateOthrPmt(int _index);
		@Override
		List<? extends OtherPayment5__1.OtherPayment5__1Builder> getOthrPmt();
		Package4__1.Package4__1Builder getOrCreatePackg();
		@Override
		Package4__1.Package4__1Builder getPackg();
		TradeTransaction50__6.TradeTransaction50__6Builder setTxId(UniqueTransactionIdentifier2Choice__1 txId);
		TradeTransaction50__6.TradeTransaction50__6Builder setCollPrtflCd(CollateralPortfolioCode6Choice__1 collPrtflCd);
		TradeTransaction50__6.TradeTransaction50__6Builder setPltfmIdr(String pltfmIdr);
		TradeTransaction50__6.TradeTransaction50__6Builder setTxPric(PriceData2__2 txPric);
		TradeTransaction50__6.TradeTransaction50__6Builder setNtnlAmt(NotionalAmountLegs5__2 ntnlAmt);
		TradeTransaction50__6.TradeTransaction50__6Builder setNtnlQty(NotionalQuantityLegs5__2 ntnlQty);
		TradeTransaction50__6.TradeTransaction50__6Builder setDlvryTp(PhysicalTransferType4Code dlvryTp);
		TradeTransaction50__6.TradeTransaction50__6Builder setExctnTmStmp(ZonedDateTime exctnTmStmp);
		TradeTransaction50__6.TradeTransaction50__6Builder setFctvDt(Date fctvDt);
		TradeTransaction50__6.TradeTransaction50__6Builder setXprtnDt(Date xprtnDt);
		TradeTransaction50__6.TradeTransaction50__6Builder setSttlmDt(Date sttlmDt);
		TradeTransaction50__6.TradeTransaction50__6Builder setDerivEvt(DerivativeEvent6__2 derivEvt);
		TradeTransaction50__6.TradeTransaction50__6Builder setTradConf(TradeConfirmation4Choice tradConf);
		TradeTransaction50__6.TradeTransaction50__6Builder setTradClr(TradeClearing11__2 tradClr);
		TradeTransaction50__6.TradeTransaction50__6Builder setIntrstRate(InterestRateLegs14__3 intrstRate);
		TradeTransaction50__6.TradeTransaction50__6Builder setCcy(CurrencyExchange22__1 ccy);
		TradeTransaction50__6.TradeTransaction50__6Builder setOptn(OptionOrSwaption11__2 optn);
		TradeTransaction50__6.TradeTransaction50__6Builder setCdt(CreditDerivative4__1 cdt);
		TradeTransaction50__6.TradeTransaction50__6Builder addOthrPmt(OtherPayment5__1 othrPmt);
		TradeTransaction50__6.TradeTransaction50__6Builder addOthrPmt(OtherPayment5__1 othrPmt, int _idx);
		TradeTransaction50__6.TradeTransaction50__6Builder addOthrPmt(List<? extends OtherPayment5__1> othrPmt);
		TradeTransaction50__6.TradeTransaction50__6Builder setOthrPmt(List<? extends OtherPayment5__1> othrPmt);
		TradeTransaction50__6.TradeTransaction50__6Builder setPackg(Package4__1 packg);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("txId"), processor, UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder.class, getTxId());
			processRosetta(path.newSubPath("collPrtflCd"), processor, CollateralPortfolioCode6Choice__1.CollateralPortfolioCode6Choice__1Builder.class, getCollPrtflCd());
			processor.processBasic(path.newSubPath("pltfmIdr"), String.class, getPltfmIdr(), this);
			processRosetta(path.newSubPath("txPric"), processor, PriceData2__2.PriceData2__2Builder.class, getTxPric());
			processRosetta(path.newSubPath("ntnlAmt"), processor, NotionalAmountLegs5__2.NotionalAmountLegs5__2Builder.class, getNtnlAmt());
			processRosetta(path.newSubPath("ntnlQty"), processor, NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder.class, getNtnlQty());
			processor.processBasic(path.newSubPath("dlvryTp"), PhysicalTransferType4Code.class, getDlvryTp(), this);
			processor.processBasic(path.newSubPath("exctnTmStmp"), ZonedDateTime.class, getExctnTmStmp(), this);
			processor.processBasic(path.newSubPath("fctvDt"), Date.class, getFctvDt(), this);
			processor.processBasic(path.newSubPath("xprtnDt"), Date.class, getXprtnDt(), this);
			processor.processBasic(path.newSubPath("sttlmDt"), Date.class, getSttlmDt(), this);
			processRosetta(path.newSubPath("derivEvt"), processor, DerivativeEvent6__2.DerivativeEvent6__2Builder.class, getDerivEvt());
			processRosetta(path.newSubPath("tradConf"), processor, TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder.class, getTradConf());
			processRosetta(path.newSubPath("tradClr"), processor, TradeClearing11__2.TradeClearing11__2Builder.class, getTradClr());
			processRosetta(path.newSubPath("intrstRate"), processor, InterestRateLegs14__3.InterestRateLegs14__3Builder.class, getIntrstRate());
			processRosetta(path.newSubPath("ccy"), processor, CurrencyExchange22__1.CurrencyExchange22__1Builder.class, getCcy());
			processRosetta(path.newSubPath("optn"), processor, OptionOrSwaption11__2.OptionOrSwaption11__2Builder.class, getOptn());
			processRosetta(path.newSubPath("cdt"), processor, CreditDerivative4__1.CreditDerivative4__1Builder.class, getCdt());
			processRosetta(path.newSubPath("othrPmt"), processor, OtherPayment5__1.OtherPayment5__1Builder.class, getOthrPmt());
			processRosetta(path.newSubPath("packg"), processor, Package4__1.Package4__1Builder.class, getPackg());
		}
		

		TradeTransaction50__6.TradeTransaction50__6Builder prune();
	}

	/*********************** Immutable Implementation of TradeTransaction50__6  ***********************/
	class TradeTransaction50__6Impl implements TradeTransaction50__6 {
		private final UniqueTransactionIdentifier2Choice__1 txId;
		private final CollateralPortfolioCode6Choice__1 collPrtflCd;
		private final String pltfmIdr;
		private final PriceData2__2 txPric;
		private final NotionalAmountLegs5__2 ntnlAmt;
		private final NotionalQuantityLegs5__2 ntnlQty;
		private final PhysicalTransferType4Code dlvryTp;
		private final ZonedDateTime exctnTmStmp;
		private final Date fctvDt;
		private final Date xprtnDt;
		private final Date sttlmDt;
		private final DerivativeEvent6__2 derivEvt;
		private final TradeConfirmation4Choice tradConf;
		private final TradeClearing11__2 tradClr;
		private final InterestRateLegs14__3 intrstRate;
		private final CurrencyExchange22__1 ccy;
		private final OptionOrSwaption11__2 optn;
		private final CreditDerivative4__1 cdt;
		private final List<? extends OtherPayment5__1> othrPmt;
		private final Package4__1 packg;
		
		protected TradeTransaction50__6Impl(TradeTransaction50__6.TradeTransaction50__6Builder builder) {
			this.txId = ofNullable(builder.getTxId()).map(f->f.build()).orElse(null);
			this.collPrtflCd = ofNullable(builder.getCollPrtflCd()).map(f->f.build()).orElse(null);
			this.pltfmIdr = builder.getPltfmIdr();
			this.txPric = ofNullable(builder.getTxPric()).map(f->f.build()).orElse(null);
			this.ntnlAmt = ofNullable(builder.getNtnlAmt()).map(f->f.build()).orElse(null);
			this.ntnlQty = ofNullable(builder.getNtnlQty()).map(f->f.build()).orElse(null);
			this.dlvryTp = builder.getDlvryTp();
			this.exctnTmStmp = builder.getExctnTmStmp();
			this.fctvDt = builder.getFctvDt();
			this.xprtnDt = builder.getXprtnDt();
			this.sttlmDt = builder.getSttlmDt();
			this.derivEvt = ofNullable(builder.getDerivEvt()).map(f->f.build()).orElse(null);
			this.tradConf = ofNullable(builder.getTradConf()).map(f->f.build()).orElse(null);
			this.tradClr = ofNullable(builder.getTradClr()).map(f->f.build()).orElse(null);
			this.intrstRate = ofNullable(builder.getIntrstRate()).map(f->f.build()).orElse(null);
			this.ccy = ofNullable(builder.getCcy()).map(f->f.build()).orElse(null);
			this.optn = ofNullable(builder.getOptn()).map(f->f.build()).orElse(null);
			this.cdt = ofNullable(builder.getCdt()).map(f->f.build()).orElse(null);
			this.othrPmt = ofNullable(builder.getOthrPmt()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.packg = ofNullable(builder.getPackg()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("txId")
		public UniqueTransactionIdentifier2Choice__1 getTxId() {
			return txId;
		}
		
		@Override
		@RosettaAttribute("collPrtflCd")
		public CollateralPortfolioCode6Choice__1 getCollPrtflCd() {
			return collPrtflCd;
		}
		
		@Override
		@RosettaAttribute("pltfmIdr")
		public String getPltfmIdr() {
			return pltfmIdr;
		}
		
		@Override
		@RosettaAttribute("txPric")
		public PriceData2__2 getTxPric() {
			return txPric;
		}
		
		@Override
		@RosettaAttribute("ntnlAmt")
		public NotionalAmountLegs5__2 getNtnlAmt() {
			return ntnlAmt;
		}
		
		@Override
		@RosettaAttribute("ntnlQty")
		public NotionalQuantityLegs5__2 getNtnlQty() {
			return ntnlQty;
		}
		
		@Override
		@RosettaAttribute("dlvryTp")
		public PhysicalTransferType4Code getDlvryTp() {
			return dlvryTp;
		}
		
		@Override
		@RosettaAttribute("exctnTmStmp")
		public ZonedDateTime getExctnTmStmp() {
			return exctnTmStmp;
		}
		
		@Override
		@RosettaAttribute("fctvDt")
		public Date getFctvDt() {
			return fctvDt;
		}
		
		@Override
		@RosettaAttribute("xprtnDt")
		public Date getXprtnDt() {
			return xprtnDt;
		}
		
		@Override
		@RosettaAttribute("sttlmDt")
		public Date getSttlmDt() {
			return sttlmDt;
		}
		
		@Override
		@RosettaAttribute("derivEvt")
		public DerivativeEvent6__2 getDerivEvt() {
			return derivEvt;
		}
		
		@Override
		@RosettaAttribute("tradConf")
		public TradeConfirmation4Choice getTradConf() {
			return tradConf;
		}
		
		@Override
		@RosettaAttribute("tradClr")
		public TradeClearing11__2 getTradClr() {
			return tradClr;
		}
		
		@Override
		@RosettaAttribute("intrstRate")
		public InterestRateLegs14__3 getIntrstRate() {
			return intrstRate;
		}
		
		@Override
		@RosettaAttribute("ccy")
		public CurrencyExchange22__1 getCcy() {
			return ccy;
		}
		
		@Override
		@RosettaAttribute("optn")
		public OptionOrSwaption11__2 getOptn() {
			return optn;
		}
		
		@Override
		@RosettaAttribute("cdt")
		public CreditDerivative4__1 getCdt() {
			return cdt;
		}
		
		@Override
		@RosettaAttribute("othrPmt")
		public List<? extends OtherPayment5__1> getOthrPmt() {
			return othrPmt;
		}
		
		@Override
		@RosettaAttribute("packg")
		public Package4__1 getPackg() {
			return packg;
		}
		
		@Override
		public TradeTransaction50__6 build() {
			return this;
		}
		
		@Override
		public TradeTransaction50__6.TradeTransaction50__6Builder toBuilder() {
			TradeTransaction50__6.TradeTransaction50__6Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(TradeTransaction50__6.TradeTransaction50__6Builder builder) {
			ofNullable(getTxId()).ifPresent(builder::setTxId);
			ofNullable(getCollPrtflCd()).ifPresent(builder::setCollPrtflCd);
			ofNullable(getPltfmIdr()).ifPresent(builder::setPltfmIdr);
			ofNullable(getTxPric()).ifPresent(builder::setTxPric);
			ofNullable(getNtnlAmt()).ifPresent(builder::setNtnlAmt);
			ofNullable(getNtnlQty()).ifPresent(builder::setNtnlQty);
			ofNullable(getDlvryTp()).ifPresent(builder::setDlvryTp);
			ofNullable(getExctnTmStmp()).ifPresent(builder::setExctnTmStmp);
			ofNullable(getFctvDt()).ifPresent(builder::setFctvDt);
			ofNullable(getXprtnDt()).ifPresent(builder::setXprtnDt);
			ofNullable(getSttlmDt()).ifPresent(builder::setSttlmDt);
			ofNullable(getDerivEvt()).ifPresent(builder::setDerivEvt);
			ofNullable(getTradConf()).ifPresent(builder::setTradConf);
			ofNullable(getTradClr()).ifPresent(builder::setTradClr);
			ofNullable(getIntrstRate()).ifPresent(builder::setIntrstRate);
			ofNullable(getCcy()).ifPresent(builder::setCcy);
			ofNullable(getOptn()).ifPresent(builder::setOptn);
			ofNullable(getCdt()).ifPresent(builder::setCdt);
			ofNullable(getOthrPmt()).ifPresent(builder::setOthrPmt);
			ofNullable(getPackg()).ifPresent(builder::setPackg);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			TradeTransaction50__6 _that = getType().cast(o);
		
			if (!Objects.equals(txId, _that.getTxId())) return false;
			if (!Objects.equals(collPrtflCd, _that.getCollPrtflCd())) return false;
			if (!Objects.equals(pltfmIdr, _that.getPltfmIdr())) return false;
			if (!Objects.equals(txPric, _that.getTxPric())) return false;
			if (!Objects.equals(ntnlAmt, _that.getNtnlAmt())) return false;
			if (!Objects.equals(ntnlQty, _that.getNtnlQty())) return false;
			if (!Objects.equals(dlvryTp, _that.getDlvryTp())) return false;
			if (!Objects.equals(exctnTmStmp, _that.getExctnTmStmp())) return false;
			if (!Objects.equals(fctvDt, _that.getFctvDt())) return false;
			if (!Objects.equals(xprtnDt, _that.getXprtnDt())) return false;
			if (!Objects.equals(sttlmDt, _that.getSttlmDt())) return false;
			if (!Objects.equals(derivEvt, _that.getDerivEvt())) return false;
			if (!Objects.equals(tradConf, _that.getTradConf())) return false;
			if (!Objects.equals(tradClr, _that.getTradClr())) return false;
			if (!Objects.equals(intrstRate, _that.getIntrstRate())) return false;
			if (!Objects.equals(ccy, _that.getCcy())) return false;
			if (!Objects.equals(optn, _that.getOptn())) return false;
			if (!Objects.equals(cdt, _that.getCdt())) return false;
			if (!ListEquals.listEquals(othrPmt, _that.getOthrPmt())) return false;
			if (!Objects.equals(packg, _that.getPackg())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (txId != null ? txId.hashCode() : 0);
			_result = 31 * _result + (collPrtflCd != null ? collPrtflCd.hashCode() : 0);
			_result = 31 * _result + (pltfmIdr != null ? pltfmIdr.hashCode() : 0);
			_result = 31 * _result + (txPric != null ? txPric.hashCode() : 0);
			_result = 31 * _result + (ntnlAmt != null ? ntnlAmt.hashCode() : 0);
			_result = 31 * _result + (ntnlQty != null ? ntnlQty.hashCode() : 0);
			_result = 31 * _result + (dlvryTp != null ? dlvryTp.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (exctnTmStmp != null ? exctnTmStmp.hashCode() : 0);
			_result = 31 * _result + (fctvDt != null ? fctvDt.hashCode() : 0);
			_result = 31 * _result + (xprtnDt != null ? xprtnDt.hashCode() : 0);
			_result = 31 * _result + (sttlmDt != null ? sttlmDt.hashCode() : 0);
			_result = 31 * _result + (derivEvt != null ? derivEvt.hashCode() : 0);
			_result = 31 * _result + (tradConf != null ? tradConf.hashCode() : 0);
			_result = 31 * _result + (tradClr != null ? tradClr.hashCode() : 0);
			_result = 31 * _result + (intrstRate != null ? intrstRate.hashCode() : 0);
			_result = 31 * _result + (ccy != null ? ccy.hashCode() : 0);
			_result = 31 * _result + (optn != null ? optn.hashCode() : 0);
			_result = 31 * _result + (cdt != null ? cdt.hashCode() : 0);
			_result = 31 * _result + (othrPmt != null ? othrPmt.hashCode() : 0);
			_result = 31 * _result + (packg != null ? packg.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "TradeTransaction50__6 {" +
				"txId=" + this.txId + ", " +
				"collPrtflCd=" + this.collPrtflCd + ", " +
				"pltfmIdr=" + this.pltfmIdr + ", " +
				"txPric=" + this.txPric + ", " +
				"ntnlAmt=" + this.ntnlAmt + ", " +
				"ntnlQty=" + this.ntnlQty + ", " +
				"dlvryTp=" + this.dlvryTp + ", " +
				"exctnTmStmp=" + this.exctnTmStmp + ", " +
				"fctvDt=" + this.fctvDt + ", " +
				"xprtnDt=" + this.xprtnDt + ", " +
				"sttlmDt=" + this.sttlmDt + ", " +
				"derivEvt=" + this.derivEvt + ", " +
				"tradConf=" + this.tradConf + ", " +
				"tradClr=" + this.tradClr + ", " +
				"intrstRate=" + this.intrstRate + ", " +
				"ccy=" + this.ccy + ", " +
				"optn=" + this.optn + ", " +
				"cdt=" + this.cdt + ", " +
				"othrPmt=" + this.othrPmt + ", " +
				"packg=" + this.packg +
			'}';
		}
	}

	/*********************** Builder Implementation of TradeTransaction50__6  ***********************/
	class TradeTransaction50__6BuilderImpl implements TradeTransaction50__6.TradeTransaction50__6Builder {
	
		protected UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder txId;
		protected CollateralPortfolioCode6Choice__1.CollateralPortfolioCode6Choice__1Builder collPrtflCd;
		protected String pltfmIdr;
		protected PriceData2__2.PriceData2__2Builder txPric;
		protected NotionalAmountLegs5__2.NotionalAmountLegs5__2Builder ntnlAmt;
		protected NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder ntnlQty;
		protected PhysicalTransferType4Code dlvryTp;
		protected ZonedDateTime exctnTmStmp;
		protected Date fctvDt;
		protected Date xprtnDt;
		protected Date sttlmDt;
		protected DerivativeEvent6__2.DerivativeEvent6__2Builder derivEvt;
		protected TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder tradConf;
		protected TradeClearing11__2.TradeClearing11__2Builder tradClr;
		protected InterestRateLegs14__3.InterestRateLegs14__3Builder intrstRate;
		protected CurrencyExchange22__1.CurrencyExchange22__1Builder ccy;
		protected OptionOrSwaption11__2.OptionOrSwaption11__2Builder optn;
		protected CreditDerivative4__1.CreditDerivative4__1Builder cdt;
		protected List<OtherPayment5__1.OtherPayment5__1Builder> othrPmt = new ArrayList<>();
		protected Package4__1.Package4__1Builder packg;
		
		@Override
		@RosettaAttribute("txId")
		public UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder getTxId() {
			return txId;
		}
		
		@Override
		public UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder getOrCreateTxId() {
			UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder result;
			if (txId!=null) {
				result = txId;
			}
			else {
				result = txId = UniqueTransactionIdentifier2Choice__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("collPrtflCd")
		public CollateralPortfolioCode6Choice__1.CollateralPortfolioCode6Choice__1Builder getCollPrtflCd() {
			return collPrtflCd;
		}
		
		@Override
		public CollateralPortfolioCode6Choice__1.CollateralPortfolioCode6Choice__1Builder getOrCreateCollPrtflCd() {
			CollateralPortfolioCode6Choice__1.CollateralPortfolioCode6Choice__1Builder result;
			if (collPrtflCd!=null) {
				result = collPrtflCd;
			}
			else {
				result = collPrtflCd = CollateralPortfolioCode6Choice__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("pltfmIdr")
		public String getPltfmIdr() {
			return pltfmIdr;
		}
		
		@Override
		@RosettaAttribute("txPric")
		public PriceData2__2.PriceData2__2Builder getTxPric() {
			return txPric;
		}
		
		@Override
		public PriceData2__2.PriceData2__2Builder getOrCreateTxPric() {
			PriceData2__2.PriceData2__2Builder result;
			if (txPric!=null) {
				result = txPric;
			}
			else {
				result = txPric = PriceData2__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("ntnlAmt")
		public NotionalAmountLegs5__2.NotionalAmountLegs5__2Builder getNtnlAmt() {
			return ntnlAmt;
		}
		
		@Override
		public NotionalAmountLegs5__2.NotionalAmountLegs5__2Builder getOrCreateNtnlAmt() {
			NotionalAmountLegs5__2.NotionalAmountLegs5__2Builder result;
			if (ntnlAmt!=null) {
				result = ntnlAmt;
			}
			else {
				result = ntnlAmt = NotionalAmountLegs5__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("ntnlQty")
		public NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder getNtnlQty() {
			return ntnlQty;
		}
		
		@Override
		public NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder getOrCreateNtnlQty() {
			NotionalQuantityLegs5__2.NotionalQuantityLegs5__2Builder result;
			if (ntnlQty!=null) {
				result = ntnlQty;
			}
			else {
				result = ntnlQty = NotionalQuantityLegs5__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("dlvryTp")
		public PhysicalTransferType4Code getDlvryTp() {
			return dlvryTp;
		}
		
		@Override
		@RosettaAttribute("exctnTmStmp")
		public ZonedDateTime getExctnTmStmp() {
			return exctnTmStmp;
		}
		
		@Override
		@RosettaAttribute("fctvDt")
		public Date getFctvDt() {
			return fctvDt;
		}
		
		@Override
		@RosettaAttribute("xprtnDt")
		public Date getXprtnDt() {
			return xprtnDt;
		}
		
		@Override
		@RosettaAttribute("sttlmDt")
		public Date getSttlmDt() {
			return sttlmDt;
		}
		
		@Override
		@RosettaAttribute("derivEvt")
		public DerivativeEvent6__2.DerivativeEvent6__2Builder getDerivEvt() {
			return derivEvt;
		}
		
		@Override
		public DerivativeEvent6__2.DerivativeEvent6__2Builder getOrCreateDerivEvt() {
			DerivativeEvent6__2.DerivativeEvent6__2Builder result;
			if (derivEvt!=null) {
				result = derivEvt;
			}
			else {
				result = derivEvt = DerivativeEvent6__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("tradConf")
		public TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder getTradConf() {
			return tradConf;
		}
		
		@Override
		public TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder getOrCreateTradConf() {
			TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder result;
			if (tradConf!=null) {
				result = tradConf;
			}
			else {
				result = tradConf = TradeConfirmation4Choice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("tradClr")
		public TradeClearing11__2.TradeClearing11__2Builder getTradClr() {
			return tradClr;
		}
		
		@Override
		public TradeClearing11__2.TradeClearing11__2Builder getOrCreateTradClr() {
			TradeClearing11__2.TradeClearing11__2Builder result;
			if (tradClr!=null) {
				result = tradClr;
			}
			else {
				result = tradClr = TradeClearing11__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("intrstRate")
		public InterestRateLegs14__3.InterestRateLegs14__3Builder getIntrstRate() {
			return intrstRate;
		}
		
		@Override
		public InterestRateLegs14__3.InterestRateLegs14__3Builder getOrCreateIntrstRate() {
			InterestRateLegs14__3.InterestRateLegs14__3Builder result;
			if (intrstRate!=null) {
				result = intrstRate;
			}
			else {
				result = intrstRate = InterestRateLegs14__3.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("ccy")
		public CurrencyExchange22__1.CurrencyExchange22__1Builder getCcy() {
			return ccy;
		}
		
		@Override
		public CurrencyExchange22__1.CurrencyExchange22__1Builder getOrCreateCcy() {
			CurrencyExchange22__1.CurrencyExchange22__1Builder result;
			if (ccy!=null) {
				result = ccy;
			}
			else {
				result = ccy = CurrencyExchange22__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("optn")
		public OptionOrSwaption11__2.OptionOrSwaption11__2Builder getOptn() {
			return optn;
		}
		
		@Override
		public OptionOrSwaption11__2.OptionOrSwaption11__2Builder getOrCreateOptn() {
			OptionOrSwaption11__2.OptionOrSwaption11__2Builder result;
			if (optn!=null) {
				result = optn;
			}
			else {
				result = optn = OptionOrSwaption11__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("cdt")
		public CreditDerivative4__1.CreditDerivative4__1Builder getCdt() {
			return cdt;
		}
		
		@Override
		public CreditDerivative4__1.CreditDerivative4__1Builder getOrCreateCdt() {
			CreditDerivative4__1.CreditDerivative4__1Builder result;
			if (cdt!=null) {
				result = cdt;
			}
			else {
				result = cdt = CreditDerivative4__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("othrPmt")
		public List<? extends OtherPayment5__1.OtherPayment5__1Builder> getOthrPmt() {
			return othrPmt;
		}
		
		@Override
		public OtherPayment5__1.OtherPayment5__1Builder getOrCreateOthrPmt(int _index) {
		
			if (othrPmt==null) {
				this.othrPmt = new ArrayList<>();
			}
			OtherPayment5__1.OtherPayment5__1Builder result;
			return getIndex(othrPmt, _index, () -> {
						OtherPayment5__1.OtherPayment5__1Builder newOthrPmt = OtherPayment5__1.builder();
						return newOthrPmt;
					});
		}
		
		@Override
		@RosettaAttribute("packg")
		public Package4__1.Package4__1Builder getPackg() {
			return packg;
		}
		
		@Override
		public Package4__1.Package4__1Builder getOrCreatePackg() {
			Package4__1.Package4__1Builder result;
			if (packg!=null) {
				result = packg;
			}
			else {
				result = packg = Package4__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("txId")
		public TradeTransaction50__6.TradeTransaction50__6Builder setTxId(UniqueTransactionIdentifier2Choice__1 _txId) {
			this.txId = _txId == null ? null : _txId.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("collPrtflCd")
		public TradeTransaction50__6.TradeTransaction50__6Builder setCollPrtflCd(CollateralPortfolioCode6Choice__1 _collPrtflCd) {
			this.collPrtflCd = _collPrtflCd == null ? null : _collPrtflCd.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("pltfmIdr")
		public TradeTransaction50__6.TradeTransaction50__6Builder setPltfmIdr(String _pltfmIdr) {
			this.pltfmIdr = _pltfmIdr == null ? null : _pltfmIdr;
			return this;
		}
		
		@Override
		@RosettaAttribute("txPric")
		public TradeTransaction50__6.TradeTransaction50__6Builder setTxPric(PriceData2__2 _txPric) {
			this.txPric = _txPric == null ? null : _txPric.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("ntnlAmt")
		public TradeTransaction50__6.TradeTransaction50__6Builder setNtnlAmt(NotionalAmountLegs5__2 _ntnlAmt) {
			this.ntnlAmt = _ntnlAmt == null ? null : _ntnlAmt.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("ntnlQty")
		public TradeTransaction50__6.TradeTransaction50__6Builder setNtnlQty(NotionalQuantityLegs5__2 _ntnlQty) {
			this.ntnlQty = _ntnlQty == null ? null : _ntnlQty.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("dlvryTp")
		public TradeTransaction50__6.TradeTransaction50__6Builder setDlvryTp(PhysicalTransferType4Code _dlvryTp) {
			this.dlvryTp = _dlvryTp == null ? null : _dlvryTp;
			return this;
		}
		
		@Override
		@RosettaAttribute("exctnTmStmp")
		public TradeTransaction50__6.TradeTransaction50__6Builder setExctnTmStmp(ZonedDateTime _exctnTmStmp) {
			this.exctnTmStmp = _exctnTmStmp == null ? null : _exctnTmStmp;
			return this;
		}
		
		@Override
		@RosettaAttribute("fctvDt")
		public TradeTransaction50__6.TradeTransaction50__6Builder setFctvDt(Date _fctvDt) {
			this.fctvDt = _fctvDt == null ? null : _fctvDt;
			return this;
		}
		
		@Override
		@RosettaAttribute("xprtnDt")
		public TradeTransaction50__6.TradeTransaction50__6Builder setXprtnDt(Date _xprtnDt) {
			this.xprtnDt = _xprtnDt == null ? null : _xprtnDt;
			return this;
		}
		
		@Override
		@RosettaAttribute("sttlmDt")
		public TradeTransaction50__6.TradeTransaction50__6Builder setSttlmDt(Date _sttlmDt) {
			this.sttlmDt = _sttlmDt == null ? null : _sttlmDt;
			return this;
		}
		
		@Override
		@RosettaAttribute("derivEvt")
		public TradeTransaction50__6.TradeTransaction50__6Builder setDerivEvt(DerivativeEvent6__2 _derivEvt) {
			this.derivEvt = _derivEvt == null ? null : _derivEvt.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("tradConf")
		public TradeTransaction50__6.TradeTransaction50__6Builder setTradConf(TradeConfirmation4Choice _tradConf) {
			this.tradConf = _tradConf == null ? null : _tradConf.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("tradClr")
		public TradeTransaction50__6.TradeTransaction50__6Builder setTradClr(TradeClearing11__2 _tradClr) {
			this.tradClr = _tradClr == null ? null : _tradClr.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("intrstRate")
		public TradeTransaction50__6.TradeTransaction50__6Builder setIntrstRate(InterestRateLegs14__3 _intrstRate) {
			this.intrstRate = _intrstRate == null ? null : _intrstRate.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("ccy")
		public TradeTransaction50__6.TradeTransaction50__6Builder setCcy(CurrencyExchange22__1 _ccy) {
			this.ccy = _ccy == null ? null : _ccy.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("optn")
		public TradeTransaction50__6.TradeTransaction50__6Builder setOptn(OptionOrSwaption11__2 _optn) {
			this.optn = _optn == null ? null : _optn.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("cdt")
		public TradeTransaction50__6.TradeTransaction50__6Builder setCdt(CreditDerivative4__1 _cdt) {
			this.cdt = _cdt == null ? null : _cdt.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("othrPmt")
		public TradeTransaction50__6.TradeTransaction50__6Builder addOthrPmt(OtherPayment5__1 _othrPmt) {
			if (_othrPmt != null) {
				this.othrPmt.add(_othrPmt.toBuilder());
			}
			return this;
		}
		
		@Override
		public TradeTransaction50__6.TradeTransaction50__6Builder addOthrPmt(OtherPayment5__1 _othrPmt, int _idx) {
			getIndex(this.othrPmt, _idx, () -> _othrPmt.toBuilder());
			return this;
		}
		
		@Override 
		public TradeTransaction50__6.TradeTransaction50__6Builder addOthrPmt(List<? extends OtherPayment5__1> othrPmts) {
			if (othrPmts != null) {
				for (final OtherPayment5__1 toAdd : othrPmts) {
					this.othrPmt.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		public TradeTransaction50__6.TradeTransaction50__6Builder setOthrPmt(List<? extends OtherPayment5__1> othrPmts) {
			if (othrPmts == null) {
				this.othrPmt = new ArrayList<>();
			} else {
				this.othrPmt = othrPmts.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("packg")
		public TradeTransaction50__6.TradeTransaction50__6Builder setPackg(Package4__1 _packg) {
			this.packg = _packg == null ? null : _packg.toBuilder();
			return this;
		}
		
		@Override
		public TradeTransaction50__6 build() {
			return new TradeTransaction50__6.TradeTransaction50__6Impl(this);
		}
		
		@Override
		public TradeTransaction50__6.TradeTransaction50__6Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public TradeTransaction50__6.TradeTransaction50__6Builder prune() {
			if (txId!=null && !txId.prune().hasData()) txId = null;
			if (collPrtflCd!=null && !collPrtflCd.prune().hasData()) collPrtflCd = null;
			if (txPric!=null && !txPric.prune().hasData()) txPric = null;
			if (ntnlAmt!=null && !ntnlAmt.prune().hasData()) ntnlAmt = null;
			if (ntnlQty!=null && !ntnlQty.prune().hasData()) ntnlQty = null;
			if (derivEvt!=null && !derivEvt.prune().hasData()) derivEvt = null;
			if (tradConf!=null && !tradConf.prune().hasData()) tradConf = null;
			if (tradClr!=null && !tradClr.prune().hasData()) tradClr = null;
			if (intrstRate!=null && !intrstRate.prune().hasData()) intrstRate = null;
			if (ccy!=null && !ccy.prune().hasData()) ccy = null;
			if (optn!=null && !optn.prune().hasData()) optn = null;
			if (cdt!=null && !cdt.prune().hasData()) cdt = null;
			othrPmt = othrPmt.stream().filter(b->b!=null).<OtherPayment5__1.OtherPayment5__1Builder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (packg!=null && !packg.prune().hasData()) packg = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getTxId()!=null && getTxId().hasData()) return true;
			if (getCollPrtflCd()!=null && getCollPrtflCd().hasData()) return true;
			if (getPltfmIdr()!=null) return true;
			if (getTxPric()!=null && getTxPric().hasData()) return true;
			if (getNtnlAmt()!=null && getNtnlAmt().hasData()) return true;
			if (getNtnlQty()!=null && getNtnlQty().hasData()) return true;
			if (getDlvryTp()!=null) return true;
			if (getExctnTmStmp()!=null) return true;
			if (getFctvDt()!=null) return true;
			if (getXprtnDt()!=null) return true;
			if (getSttlmDt()!=null) return true;
			if (getDerivEvt()!=null && getDerivEvt().hasData()) return true;
			if (getTradConf()!=null && getTradConf().hasData()) return true;
			if (getTradClr()!=null && getTradClr().hasData()) return true;
			if (getIntrstRate()!=null && getIntrstRate().hasData()) return true;
			if (getCcy()!=null && getCcy().hasData()) return true;
			if (getOptn()!=null && getOptn().hasData()) return true;
			if (getCdt()!=null && getCdt().hasData()) return true;
			if (getOthrPmt()!=null && getOthrPmt().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getPackg()!=null && getPackg().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public TradeTransaction50__6.TradeTransaction50__6Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			TradeTransaction50__6.TradeTransaction50__6Builder o = (TradeTransaction50__6.TradeTransaction50__6Builder) other;
			
			merger.mergeRosetta(getTxId(), o.getTxId(), this::setTxId);
			merger.mergeRosetta(getCollPrtflCd(), o.getCollPrtflCd(), this::setCollPrtflCd);
			merger.mergeRosetta(getTxPric(), o.getTxPric(), this::setTxPric);
			merger.mergeRosetta(getNtnlAmt(), o.getNtnlAmt(), this::setNtnlAmt);
			merger.mergeRosetta(getNtnlQty(), o.getNtnlQty(), this::setNtnlQty);
			merger.mergeRosetta(getDerivEvt(), o.getDerivEvt(), this::setDerivEvt);
			merger.mergeRosetta(getTradConf(), o.getTradConf(), this::setTradConf);
			merger.mergeRosetta(getTradClr(), o.getTradClr(), this::setTradClr);
			merger.mergeRosetta(getIntrstRate(), o.getIntrstRate(), this::setIntrstRate);
			merger.mergeRosetta(getCcy(), o.getCcy(), this::setCcy);
			merger.mergeRosetta(getOptn(), o.getOptn(), this::setOptn);
			merger.mergeRosetta(getCdt(), o.getCdt(), this::setCdt);
			merger.mergeRosetta(getOthrPmt(), o.getOthrPmt(), this::getOrCreateOthrPmt);
			merger.mergeRosetta(getPackg(), o.getPackg(), this::setPackg);
			
			merger.mergeBasic(getPltfmIdr(), o.getPltfmIdr(), this::setPltfmIdr);
			merger.mergeBasic(getDlvryTp(), o.getDlvryTp(), this::setDlvryTp);
			merger.mergeBasic(getExctnTmStmp(), o.getExctnTmStmp(), this::setExctnTmStmp);
			merger.mergeBasic(getFctvDt(), o.getFctvDt(), this::setFctvDt);
			merger.mergeBasic(getXprtnDt(), o.getXprtnDt(), this::setXprtnDt);
			merger.mergeBasic(getSttlmDt(), o.getSttlmDt(), this::setSttlmDt);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			TradeTransaction50__6 _that = getType().cast(o);
		
			if (!Objects.equals(txId, _that.getTxId())) return false;
			if (!Objects.equals(collPrtflCd, _that.getCollPrtflCd())) return false;
			if (!Objects.equals(pltfmIdr, _that.getPltfmIdr())) return false;
			if (!Objects.equals(txPric, _that.getTxPric())) return false;
			if (!Objects.equals(ntnlAmt, _that.getNtnlAmt())) return false;
			if (!Objects.equals(ntnlQty, _that.getNtnlQty())) return false;
			if (!Objects.equals(dlvryTp, _that.getDlvryTp())) return false;
			if (!Objects.equals(exctnTmStmp, _that.getExctnTmStmp())) return false;
			if (!Objects.equals(fctvDt, _that.getFctvDt())) return false;
			if (!Objects.equals(xprtnDt, _that.getXprtnDt())) return false;
			if (!Objects.equals(sttlmDt, _that.getSttlmDt())) return false;
			if (!Objects.equals(derivEvt, _that.getDerivEvt())) return false;
			if (!Objects.equals(tradConf, _that.getTradConf())) return false;
			if (!Objects.equals(tradClr, _that.getTradClr())) return false;
			if (!Objects.equals(intrstRate, _that.getIntrstRate())) return false;
			if (!Objects.equals(ccy, _that.getCcy())) return false;
			if (!Objects.equals(optn, _that.getOptn())) return false;
			if (!Objects.equals(cdt, _that.getCdt())) return false;
			if (!ListEquals.listEquals(othrPmt, _that.getOthrPmt())) return false;
			if (!Objects.equals(packg, _that.getPackg())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (txId != null ? txId.hashCode() : 0);
			_result = 31 * _result + (collPrtflCd != null ? collPrtflCd.hashCode() : 0);
			_result = 31 * _result + (pltfmIdr != null ? pltfmIdr.hashCode() : 0);
			_result = 31 * _result + (txPric != null ? txPric.hashCode() : 0);
			_result = 31 * _result + (ntnlAmt != null ? ntnlAmt.hashCode() : 0);
			_result = 31 * _result + (ntnlQty != null ? ntnlQty.hashCode() : 0);
			_result = 31 * _result + (dlvryTp != null ? dlvryTp.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (exctnTmStmp != null ? exctnTmStmp.hashCode() : 0);
			_result = 31 * _result + (fctvDt != null ? fctvDt.hashCode() : 0);
			_result = 31 * _result + (xprtnDt != null ? xprtnDt.hashCode() : 0);
			_result = 31 * _result + (sttlmDt != null ? sttlmDt.hashCode() : 0);
			_result = 31 * _result + (derivEvt != null ? derivEvt.hashCode() : 0);
			_result = 31 * _result + (tradConf != null ? tradConf.hashCode() : 0);
			_result = 31 * _result + (tradClr != null ? tradClr.hashCode() : 0);
			_result = 31 * _result + (intrstRate != null ? intrstRate.hashCode() : 0);
			_result = 31 * _result + (ccy != null ? ccy.hashCode() : 0);
			_result = 31 * _result + (optn != null ? optn.hashCode() : 0);
			_result = 31 * _result + (cdt != null ? cdt.hashCode() : 0);
			_result = 31 * _result + (othrPmt != null ? othrPmt.hashCode() : 0);
			_result = 31 * _result + (packg != null ? packg.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "TradeTransaction50__6Builder {" +
				"txId=" + this.txId + ", " +
				"collPrtflCd=" + this.collPrtflCd + ", " +
				"pltfmIdr=" + this.pltfmIdr + ", " +
				"txPric=" + this.txPric + ", " +
				"ntnlAmt=" + this.ntnlAmt + ", " +
				"ntnlQty=" + this.ntnlQty + ", " +
				"dlvryTp=" + this.dlvryTp + ", " +
				"exctnTmStmp=" + this.exctnTmStmp + ", " +
				"fctvDt=" + this.fctvDt + ", " +
				"xprtnDt=" + this.xprtnDt + ", " +
				"sttlmDt=" + this.sttlmDt + ", " +
				"derivEvt=" + this.derivEvt + ", " +
				"tradConf=" + this.tradConf + ", " +
				"tradClr=" + this.tradClr + ", " +
				"intrstRate=" + this.intrstRate + ", " +
				"ccy=" + this.ccy + ", " +
				"optn=" + this.optn + ", " +
				"cdt=" + this.cdt + ", " +
				"othrPmt=" + this.othrPmt + ", " +
				"packg=" + this.packg +
			'}';
		}
	}
}
