package iso20022.auth030.jfsa.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.jfsa.UniqueTransactionIdentifier1Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("UniqueTransactionIdentifier1Choice__1Choice")
@ImplementedBy(UniqueTransactionIdentifier1Choice1Choice.Default.class)
public interface UniqueTransactionIdentifier1Choice1Choice extends Validator<UniqueTransactionIdentifier1Choice__1> {
	
	String NAME = "UniqueTransactionIdentifier1Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<UniqueTransactionIdentifier1Choice__1> validate(RosettaPath path, UniqueTransactionIdentifier1Choice__1 uniqueTransactionIdentifier1Choice__1);
	
	class Default implements UniqueTransactionIdentifier1Choice1Choice {
	
		@Override
		public ValidationResult<UniqueTransactionIdentifier1Choice__1> validate(RosettaPath path, UniqueTransactionIdentifier1Choice__1 uniqueTransactionIdentifier1Choice__1) {
			ComparisonResult result = executeDataRule(uniqueTransactionIdentifier1Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "UniqueTransactionIdentifier1Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "UniqueTransactionIdentifier1Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(UniqueTransactionIdentifier1Choice__1 uniqueTransactionIdentifier1Choice__1) {
			try {
				return choice(MapperS.of(uniqueTransactionIdentifier1Choice__1), Arrays.asList("unqTxIdr", "prtry"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements UniqueTransactionIdentifier1Choice1Choice {
	
		@Override
		public ValidationResult<UniqueTransactionIdentifier1Choice__1> validate(RosettaPath path, UniqueTransactionIdentifier1Choice__1 uniqueTransactionIdentifier1Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "UniqueTransactionIdentifier1Choice__1", path, DEFINITION);
		}
	}
}
