package iso20022.auth030.mas.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.mas.Direction2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class Direction2TypeFormatValidator implements Validator<Direction2> {

	private List<ComparisonResult> getComparisonResults(Direction2 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public ValidationResult<Direction2> validate(RosettaPath path, Direction2 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("Direction2", ValidationType.TYPE_FORMAT, "Direction2", path, "", error);
		}
		return success("Direction2", ValidationType.TYPE_FORMAT, "Direction2", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, Direction2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("Direction2", ValidationType.TYPE_FORMAT, "Direction2", path, "", res.getError());
				}
				return success("Direction2", ValidationType.TYPE_FORMAT, "Direction2", path, "");
			})
			.collect(toList());
	}

}
