package drr.enrichment.common.trade.functions;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.Party;
import cdm.event.common.ActionEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.Instruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_BusinessEvent;
import cdm.event.workflow.EventInstruction;
import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.MessageInformation;
import cdm.event.workflow.WorkflowStep;
import cdm.event.workflow.metafields.ReferenceWithMetaWorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Create_CancelledWorkflowStepFromInstruction.Create_CancelledWorkflowStepFromInstructionDefault.class)
public abstract class Create_CancelledWorkflowStepFromInstruction implements RosettaFunction {
	
	@Inject protected ConditionValidator conditionValidator;
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_BusinessEvent create_BusinessEvent;

	/**
	* @param originatingWorkflowStep 
	* @return cancelledWorkflowStep 
	*/
	public WorkflowStep evaluate(WorkflowStep originatingWorkflowStep) {
		// pre-conditions
		conditionValidator.validate(() -> exists(MapperS.of(originatingWorkflowStep).<EventInstruction>map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent())),
			"The previous step being accepted must be a proposed step containing an instruction.");
		
		conditionValidator.validate(() -> areEqual(MapperS.of(originatingWorkflowStep).<ActionEnum>map("getAction", workflowStep -> workflowStep.getAction()), MapperS.of(ActionEnum.CANCEL), CardinalityOperator.All),
			"You cannot accept a business event on a cancelled previous step.");
		
		conditionValidator.validate(() -> notEqual(MapperS.of(originatingWorkflowStep).<Boolean>map("getRejected", workflowStep -> workflowStep.getRejected()), MapperS.of(true), CardinalityOperator.Any),
			"The previous step cannot be rejected.");
		
		WorkflowStep.WorkflowStepBuilder cancelledWorkflowStepBuilder = doEvaluate(originatingWorkflowStep);
		
		final WorkflowStep cancelledWorkflowStep;
		if (cancelledWorkflowStepBuilder == null) {
			cancelledWorkflowStep = null;
		} else {
			cancelledWorkflowStep = cancelledWorkflowStepBuilder.build();
			objectValidator.validate(WorkflowStep.class, cancelledWorkflowStep);
		}
		
		return cancelledWorkflowStep;
	}

	protected abstract WorkflowStep.WorkflowStepBuilder doEvaluate(WorkflowStep originatingWorkflowStep);

	public static class Create_CancelledWorkflowStepFromInstructionDefault extends Create_CancelledWorkflowStepFromInstruction {
		@Override
		protected WorkflowStep.WorkflowStepBuilder doEvaluate(WorkflowStep originatingWorkflowStep) {
			WorkflowStep.WorkflowStepBuilder cancelledWorkflowStep = WorkflowStep.builder();
			return assignOutput(cancelledWorkflowStep, originatingWorkflowStep);
		}
		
		protected WorkflowStep.WorkflowStepBuilder assignOutput(WorkflowStep.WorkflowStepBuilder cancelledWorkflowStep, WorkflowStep originatingWorkflowStep) {
			cancelledWorkflowStep
				.setAction(MapperS.of(originatingWorkflowStep).<ActionEnum>map("getAction", workflowStep -> workflowStep.getAction()).get());
			
			cancelledWorkflowStep
				.setMessageInformation(MapperS.of(originatingWorkflowStep).<MessageInformation>map("getMessageInformation", workflowStep -> workflowStep.getMessageInformation()).get());
			
			cancelledWorkflowStep
				.addTimestamp(MapperS.of(originatingWorkflowStep).<EventTimestamp>mapC("getTimestamp", workflowStep -> workflowStep.getTimestamp()).getMulti());
			
			cancelledWorkflowStep
				.addEventIdentifier(MapperS.of(originatingWorkflowStep).<Identifier>mapC("getEventIdentifier", workflowStep -> workflowStep.getEventIdentifier()).getMulti());
			
			final ReferenceWithMetaWorkflowStep referenceWithMetaWorkflowStep = MapperS.of(originatingWorkflowStep).<ReferenceWithMetaWorkflowStep>map("getPreviousWorkflowStep", workflowStep -> workflowStep.getPreviousWorkflowStep()).get();
			final WorkflowStep cancelledWorkflowStepPreviousWorkflowStep = referenceWithMetaWorkflowStep == null ? null : referenceWithMetaWorkflowStep.getValue();
			cancelledWorkflowStep
				.setPreviousWorkflowStep(ReferenceWithMetaWorkflowStep.builder()
					.setGlobalReference(Optional.ofNullable(cancelledWorkflowStepPreviousWorkflowStep)
						.map(r -> r.getMeta())
						.map(m -> m.getGlobalKey())
						.orElse(null))
					.setExternalReference(Optional.ofNullable(cancelledWorkflowStepPreviousWorkflowStep)
						.map(r -> r.getMeta())
						.map(m -> m.getExternalKey())
						.orElse(null))
					.build()
				);
			
			cancelledWorkflowStep
				.setBusinessEvent(create_BusinessEvent.evaluate(MapperS.of(originatingWorkflowStep).<EventInstruction>map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent()).<Instruction>mapC("getInstruction", eventInstruction -> eventInstruction.getInstruction()).getMulti(), MapperS.of(originatingWorkflowStep).<EventInstruction>map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent()).<EventIntentEnum>map("getIntent", eventInstruction -> eventInstruction.getIntent()).get(), MapperS.of(originatingWorkflowStep).<EventInstruction>map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent()).<Date>map("getEventDate", eventInstruction -> eventInstruction.getEventDate()).get(), MapperS.of(originatingWorkflowStep).<EventInstruction>map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent()).<Date>map("getEffectiveDate", eventInstruction -> eventInstruction.getEffectiveDate()).get()));
			
			cancelledWorkflowStep
				.addParty(distinct(MapperS.of(cancelledWorkflowStep).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<TradeState>mapC("getAfter", businessEvent -> businessEvent.getAfter()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<Party>mapC("getParty", trade -> trade.getParty())).getMulti());
			
			cancelledWorkflowStep
				.addAccount(distinct(MapperS.of(cancelledWorkflowStep).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<TradeState>mapC("getAfter", businessEvent -> businessEvent.getAfter()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<Account>mapC("getAccount", trade -> trade.getAccount())).getMulti());
			
			return Optional.ofNullable(cancelledWorkflowStep)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
