package drr.enrichment.common.trade.functions;

import cdm.event.common.ActionEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.common.CounterpartyPositionState;
import cdm.event.common.TradeState;
import cdm.event.workflow.EventInstruction;
import cdm.event.workflow.WorkflowStep;
import cdm.event.workflow.functions.Create_AcceptedWorkflowStepFromInstruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Create_ReportableEventFromInstruction.Create_ReportableEventFromInstructionDefault.class)
public abstract class Create_ReportableEventFromInstruction implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_AcceptedWorkflowStepFromInstruction create_AcceptedWorkflowStepFromInstruction;
	@Inject protected Create_CancelledWorkflowStepFromInstruction create_CancelledWorkflowStepFromInstruction;

	/**
	* @param reportableEvent 
	* @return enrichedReportableEvent 
	*/
	public ReportableEvent evaluate(ReportableEvent reportableEvent) {
		ReportableEvent.ReportableEventBuilder enrichedReportableEventBuilder = doEvaluate(reportableEvent);
		
		final ReportableEvent enrichedReportableEvent;
		if (enrichedReportableEventBuilder == null) {
			enrichedReportableEvent = null;
		} else {
			enrichedReportableEvent = enrichedReportableEventBuilder.build();
			objectValidator.validate(ReportableEvent.class, enrichedReportableEvent);
		}
		
		return enrichedReportableEvent;
	}

	protected abstract ReportableEvent.ReportableEventBuilder doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends WorkflowStep> originatingWorkflowStep(ReportableEvent reportableEvent);

	public static class Create_ReportableEventFromInstructionDefault extends Create_ReportableEventFromInstruction {
		@Override
		protected ReportableEvent.ReportableEventBuilder doEvaluate(ReportableEvent reportableEvent) {
			ReportableEvent.ReportableEventBuilder enrichedReportableEvent = ReportableEvent.builder();
			return assignOutput(enrichedReportableEvent, reportableEvent);
		}
		
		protected ReportableEvent.ReportableEventBuilder assignOutput(ReportableEvent.ReportableEventBuilder enrichedReportableEvent, ReportableEvent reportableEvent) {
			final WorkflowStep ifThenElseResult;
			if (notExists(originatingWorkflowStep(reportableEvent).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent())).andNullSafe(exists(originatingWorkflowStep(reportableEvent).<EventInstruction>map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent()))).andNullSafe(areEqual(originatingWorkflowStep(reportableEvent).<ActionEnum>map("getAction", workflowStep -> workflowStep.getAction()), MapperS.of(ActionEnum.CANCEL), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult = create_CancelledWorkflowStepFromInstruction.evaluate(originatingWorkflowStep(reportableEvent).get());
			} else if (notExists(originatingWorkflowStep(reportableEvent).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent())).andNullSafe(exists(originatingWorkflowStep(reportableEvent).<EventInstruction>map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent()))).getOrDefault(false)) {
				ifThenElseResult = create_AcceptedWorkflowStepFromInstruction.evaluate(originatingWorkflowStep(reportableEvent).get());
			} else {
				ifThenElseResult = originatingWorkflowStep(reportableEvent).get();
			}
			enrichedReportableEvent = toBuilder(ReportableEvent.builder()
				.setOriginatingWorkflowStep(ifThenElseResult)
				.setReportableTrade(MapperS.of(reportableEvent).<TradeState>map("getReportableTrade", _reportableEvent -> _reportableEvent.getReportableTrade()).get())
				.setReportableInformation(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get())
				.setReportablePosition(MapperS.of(reportableEvent).<CounterpartyPositionState>map("getReportablePosition", _reportableEvent -> _reportableEvent.getReportablePosition()).get())
				.build());
			
			return Optional.ofNullable(enrichedReportableEvent)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends WorkflowStep> originatingWorkflowStep(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep());
		}
	}
}
